/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import jexx.crypto.CryptoException;
import jexx.exception.UtilException;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.util.Base64Util;
import jexx.util.StringUtil;

public class KeyUtil {
    public static final String DEFAULT_KEY_ALGORITHM = "RSA";

    public static KeyPair getKeyPair(File certificate, String password) {
        return KeyUtil.getKeyPair(FileUtil.newBufferedInputStream(certificate), password);
    }

    public static KeyPair getKeyPair(InputStream certificateInputStream, String password) {
        try {
            char[] cPassword = null;
            if (StringUtil.isNotBlank(password)) {
                cPassword = password.toCharArray();
            }
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(certificateInputStream, cPassword);
            Enumeration<String> aliases = keyStore.aliases();
            String keyAlias = null;
            if (aliases.hasMoreElements()) {
                keyAlias = aliases.nextElement();
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, cPassword);
            Certificate cert = keyStore.getCertificate(keyAlias);
            PublicKey publicKey = cert.getPublicKey();
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
        finally {
            IOUtil.closeQuietly((Closeable)certificateInputStream);
        }
    }

    public static KeyPair createKeyPair() {
        return KeyUtil.createKeyPair(DEFAULT_KEY_ALGORITHM, 1024);
    }

    public static KeyPair createKeyPair(String algorithm, int keySize) {
        try {
            KeyPairGenerator myKeyGen = KeyPairGenerator.getInstance(algorithm);
            myKeyGen.initialize(keySize);
            return myKeyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey createPrivateKey(byte[] key) {
        return KeyUtil.createPrivateKey(DEFAULT_KEY_ALGORITHM, key);
    }

    public static PrivateKey createPrivateKey(String algorithm, byte[] key) {
        return KeyUtil.createPrivateKeyPKCS8(algorithm, key);
    }

    public static PrivateKey createPrivateKeyPKCS8(String algorithm, byte[] privateKey) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey createPrivateKeyPKCS8(String algorithm, String privateKey) {
        byte[] key = Base64Util.decode(privateKey);
        return KeyUtil.createPrivateKeyPKCS8(algorithm, key);
    }

    public static PublicKey createPublicKey(byte[] key) {
        return KeyUtil.createPublicKey(DEFAULT_KEY_ALGORITHM, key);
    }

    public static PublicKey createPublicKey(String algorithm, byte[] key) {
        return KeyUtil.createPublicKeyX509(algorithm, key);
    }

    public static PublicKey createPublicKeyX509(String algorithm, byte[] publicKey) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static PublicKey createPublicKeyX509(String algorithm, String publicKey) {
        byte[] decodedKey = Base64Util.decode(publicKey);
        return KeyUtil.createPublicKeyX509(algorithm, decodedKey);
    }
}

