/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import jexx.codec.Hex;
import jexx.crypto.HmacAlgorithms;
import jexx.exception.IORuntimeException;
import jexx.util.StringUtil;

public class HmacUtil {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public static byte[] hmac(byte[] data, byte[] key, HmacAlgorithms algorithms) {
        Mac mac = HmacUtil.getInitializedMac(algorithms, key);
        return mac.doFinal(data);
    }

    public static byte[] hmac(InputStream data, byte[] key, HmacAlgorithms algorithms) {
        Mac mac = HmacUtil.getInitializedMac(algorithms, key);
        return HmacUtil.updateHmac(mac, data).doFinal();
    }

    public static byte[] hmac(String data, String key, HmacAlgorithms algorithms) {
        return HmacUtil.hmac(StringUtil.getBytes(data), StringUtil.getBytes(key), algorithms);
    }

    public static String hmacHex(byte[] data, byte[] key, HmacAlgorithms algorithms) {
        return Hex.encodeHexString(HmacUtil.hmac(data, key, algorithms));
    }

    public static String hmacHex(InputStream data, byte[] key, HmacAlgorithms algorithms) {
        return Hex.encodeHexString(HmacUtil.hmac(data, key, algorithms));
    }

    public static String hmacHex(String data, String key, HmacAlgorithms algorithms) {
        return Hex.encodeHexString(HmacUtil.hmac(data, key, algorithms));
    }

    public static byte[] hmacSha256(byte[] data, byte[] key) {
        return HmacUtil.hmac(data, key, HmacAlgorithms.HMAC_SHA_256);
    }

    public static byte[] hmacSha256(InputStream data, byte[] key) {
        return HmacUtil.hmac(data, key, HmacAlgorithms.HMAC_SHA_256);
    }

    public static byte[] hmacSha256(String data, String key) {
        return HmacUtil.hmac(data, key, HmacAlgorithms.HMAC_SHA_256);
    }

    public static String hmacSha256Hex(byte[] data, byte[] key) {
        return HmacUtil.hmacHex(data, key, HmacAlgorithms.HMAC_SHA_256);
    }

    public static String hmacSha256Hex(InputStream data, byte[] key) {
        return HmacUtil.hmacHex(data, key, HmacAlgorithms.HMAC_SHA_256);
    }

    public static String hmacSha256Hex(String data, String key) {
        return HmacUtil.hmacHex(data, key, HmacAlgorithms.HMAC_SHA_256);
    }

    private static Mac getInitializedMac(HmacAlgorithms algorithm, byte[] key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm.toString());
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(keySpec);
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Mac updateHmac(Mac mac, InputStream inputStream) {
        try {
            mac.reset();
            byte[] buffer = new byte[1024];
            int read = inputStream.read(buffer, 0, 1024);
            while (read > -1) {
                mac.update(buffer, 0, read);
                read = inputStream.read(buffer, 0, 1024);
            }
            return mac;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

