/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import jexx.codec.Hex;
import jexx.exception.IORuntimeException;
import jexx.util.StringUtil;

public class DigestUtil {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    private static byte[] digest(MessageDigest digest, InputStream data) {
        return DigestUtil.updateDigest(digest, data).digest();
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MessageDigest getMd2Digest() {
        return DigestUtil.getDigest("MD2");
    }

    public static MessageDigest getMd5Digest() {
        return DigestUtil.getDigest("MD5");
    }

    public static MessageDigest getSha1Digest() {
        return DigestUtil.getDigest("SHA-1");
    }

    public static MessageDigest getSha256Digest() {
        return DigestUtil.getDigest("SHA-256");
    }

    public static MessageDigest getSha384Digest() {
        return DigestUtil.getDigest("SHA-384");
    }

    public static MessageDigest getSha512Digest() {
        return DigestUtil.getDigest("SHA-512");
    }

    @Deprecated
    public static MessageDigest getShaDigest() {
        return DigestUtil.getSha1Digest();
    }

    public static byte[] md2(byte[] data) {
        return DigestUtil.getMd2Digest().digest(data);
    }

    public static byte[] md2(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getMd2Digest(), data);
    }

    public static byte[] md2(String data) {
        return DigestUtil.md2(StringUtil.getBytes(data));
    }

    public static String md2Hex(byte[] data) {
        return Hex.encodeHexString(DigestUtil.md2(data));
    }

    public static String md2Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(DigestUtil.md2(data));
    }

    public static String md2Hex(String data) {
        return Hex.encodeHexString(DigestUtil.md2(data));
    }

    public static byte[] md5(byte[] data) {
        return DigestUtil.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) {
        return DigestUtil.digest(DigestUtil.getMd5Digest(), data);
    }

    public static byte[] md5(String data) {
        return DigestUtil.md5(StringUtil.getBytes(data));
    }

    public static byte[] md5(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] byArray = DigestUtil.md5(inputStream);
            return byArray;
        }
    }

    public static String md5Hex(byte[] data) {
        return Hex.encodeHexString(DigestUtil.md5(data));
    }

    public static String md5Hex(InputStream data) {
        return Hex.encodeHexString(DigestUtil.md5(data));
    }

    public static String md5Hex(String data) {
        return Hex.encodeHexString(DigestUtil.md5(data));
    }

    public static String md5Hex(File file) throws IOException {
        return Hex.encodeHexString(DigestUtil.md5(file));
    }

    public static byte[] sha1(byte[] data) {
        return DigestUtil.getSha1Digest().digest(data);
    }

    public static byte[] sha1(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha1Digest(), data);
    }

    public static byte[] sha1(String data) {
        return DigestUtil.sha1(StringUtil.getBytes(data));
    }

    public static String sha1Hex(byte[] data) {
        return Hex.encodeHexString(DigestUtil.sha1(data));
    }

    public static String sha1Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(DigestUtil.sha1(data));
    }

    public static String sha1Hex(String data) {
        return Hex.encodeHexString(DigestUtil.sha1(data));
    }

    public static byte[] sha256(byte[] data) {
        return DigestUtil.getSha256Digest().digest(data);
    }

    public static byte[] sha256(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha256Digest(), data);
    }

    public static byte[] sha256(String data) {
        return DigestUtil.sha256(StringUtil.getBytes(data));
    }

    public static String sha256Hex(byte[] data) {
        return Hex.encodeHexString(DigestUtil.sha256(data));
    }

    public static String sha256Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(DigestUtil.sha256(data));
    }

    public static String sha256Hex(String data) {
        return Hex.encodeHexString(DigestUtil.sha256(data));
    }

    public static byte[] sha384(byte[] data) {
        return DigestUtil.getSha384Digest().digest(data);
    }

    public static byte[] sha384(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha384Digest(), data);
    }

    public static byte[] sha384(String data) {
        return DigestUtil.sha384(StringUtil.getBytes(data));
    }

    public static String sha384Hex(byte[] data) {
        return Hex.encodeHexString(DigestUtil.sha384(data));
    }

    public static String sha384Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(DigestUtil.sha384(data));
    }

    public static String sha384Hex(String data) {
        return Hex.encodeHexString(DigestUtil.sha384(data));
    }

    public static byte[] sha512(byte[] data) {
        return DigestUtil.getSha512Digest().digest(data);
    }

    public static byte[] sha512(InputStream data) throws IOException {
        return DigestUtil.digest(DigestUtil.getSha512Digest(), data);
    }

    public static byte[] sha512(String data) {
        return DigestUtil.sha512(StringUtil.getBytes(data));
    }

    public static String sha512Hex(byte[] data) {
        return Hex.encodeHexString(DigestUtil.sha512(data));
    }

    public static String sha512Hex(InputStream data) throws IOException {
        return Hex.encodeHexString(DigestUtil.sha512(data));
    }

    public static String sha512Hex(String data) {
        return Hex.encodeHexString(DigestUtil.sha512(data));
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, byte[] valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, InputStream data) {
        try {
            byte[] buffer = new byte[1024];
            int read = data.read(buffer, 0, 1024);
            while (read > -1) {
                digest.update(buffer, 0, read);
                read = data.read(buffer, 0, 1024);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, String valueToDigest) {
        messageDigest.update(StringUtil.getBytes(valueToDigest));
        return messageDigest;
    }
}

