/*
 * Decompiled with CFR 0.152.
 */
package jexx.crypto;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import jexx.crypto.CryptoException;
import jexx.util.Base64Util;
import jexx.util.StringUtil;

public abstract class BaseCipher {
    protected String transformation;
    protected Cipher cipher;

    public BaseCipher(String transformation) {
        try {
            this.transformation = transformation;
            this.cipher = Cipher.getInstance(transformation);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    protected byte[] encrypt(Key key, byte[] input) {
        try {
            this.cipher.init(1, key);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    protected byte[] encrypt(Key key, byte[] input, AlgorithmParameters params) {
        try {
            this.cipher.init(1, key, params);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    protected byte[] encrypt(Key key, byte[] input, AlgorithmParameterSpec params) {
        try {
            this.cipher.init(1, key, params);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    protected byte[] decrypt(Key key, byte[] input) {
        try {
            this.cipher.init(2, key);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    protected byte[] decrypt(Key key, byte[] input, AlgorithmParameters params) {
        try {
            this.cipher.init(2, key, params);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    protected byte[] decrypt(Key key, byte[] input, AlgorithmParameterSpec params) {
        try {
            this.cipher.init(2, key, params);
            return this.cipher.doFinal(input);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    protected abstract byte[] encrypt(byte[] var1);

    public byte[] encryptAsBase64(byte[] data) {
        byte[] buffer = this.encrypt(data);
        return Base64Util.encode(buffer);
    }

    public String encryptAsBase64(String data) {
        byte[] buffer = this.encryptAsBase64(StringUtil.getBytes(data));
        return StringUtil.str(buffer);
    }

    protected abstract byte[] decrypt(byte[] var1);

    public byte[] decryptAsBase64(byte[] data) {
        byte[] buffer = Base64Util.decode(data);
        return this.decrypt(buffer);
    }

    public String decryptAsBase64(String data) {
        byte[] buffer = this.decryptAsBase64(StringUtil.getBytes(data));
        return StringUtil.str(buffer);
    }
}

