/*
 * Decompiled with CFR 0.152.
 */
package jexx.convert.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import jexx.convert.AbstractConverter;
import jexx.time.DateUtil;
import jexx.util.StringUtil;

public class DateConverter
extends AbstractConverter<Date> {
    private Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value) {
        long mills = 0L;
        if (value instanceof Calendar) {
            mills = ((Calendar)value).getTimeInMillis();
        }
        if (value instanceof Long) {
            mills = (Long)value;
        }
        String valueStr = this.convertToStr(value);
        try {
            mills = StringUtil.isBlank(this.format) ? DateUtil.parse(valueStr).getTime() : DateUtil.parse(valueStr, this.format).getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (0L == mills) {
            return null;
        }
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StringUtil.format("Unsupport Date type: {}", this.targetType.getName()));
    }
}

