/*
 * Decompiled with CFR 0.152.
 */
package jexx.convert.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jexx.convert.AbstractConverter;
import jexx.convert.ConverterRegistry;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.CollectionUtil;

public class ArrayConverter
extends AbstractConverter<Object> {
    private final Class<?> targetType;
    private final Class<?> targetComponentType;

    public ArrayConverter(Class<?> targetType) {
        if (null == targetType) {
            targetType = Object[].class;
        } else {
            Assert.isTrue(targetType.isArray(), "Target type must be a array!", new Object[0]);
        }
        this.targetType = targetType;
        this.targetComponentType = targetType.getComponentType();
    }

    @Override
    protected Object convertInternal(Object value) {
        return value.getClass().isArray() ? this.convertArrayToArray(value) : this.convertObjectToArray(value);
    }

    @Override
    public Class getTargetType() {
        return this.targetType;
    }

    private Object convertArrayToArray(Object array) {
        Class<?> valueComponentType = ArrayUtil.getComponentType(array);
        if (valueComponentType == this.targetComponentType) {
            return array;
        }
        int len = ArrayUtil.length(array);
        ?[] result = ArrayUtil.newArray(this.targetComponentType, len);
        ConverterRegistry converter = ConverterRegistry.getInstance();
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, converter.convert(this.targetComponentType, Array.get(array, i)));
        }
        return result;
    }

    private Object convertObjectToArray(Object value) {
        if (value instanceof CharSequence) {
            if (this.targetComponentType == Character.TYPE || this.targetComponentType == Character.class) {
                return this.convertArrayToArray(value.toString().toCharArray());
            }
            String[] strings = value.toString().split(",");
            return this.convertArrayToArray(strings);
        }
        ConverterRegistry converter = ConverterRegistry.getInstance();
        Object result = null;
        if (value instanceof List) {
            List list = (List)value;
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, converter.convert(this.targetComponentType, list.get(i)));
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            result = Array.newInstance(this.targetComponentType, collection.size());
            int i = 0;
            for (Object element : collection) {
                Array.set(result, i, converter.convert(this.targetComponentType, element));
                ++i;
            }
        } else if (value instanceof Iterable) {
            List<Object> list = CollectionUtil.list(value);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, converter.convert(this.targetComponentType, list.get(i)));
            }
        } else if (value instanceof Iterator) {
            List list = CollectionUtil.list((Iterator)value);
            result = Array.newInstance(this.targetComponentType, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(result, i, converter.convert(this.targetComponentType, list.get(i)));
            }
        } else {
            result = this.convertToSingleElementArray(value);
        }
        return result;
    }

    private Object[] convertToSingleElementArray(Object value) {
        Object[] singleElementArray = ArrayUtil.newArray(this.targetComponentType, 1);
        singleElementArray[0] = ConverterRegistry.getInstance().convert(this.targetComponentType, value);
        return singleElementArray;
    }
}

