/*
 * Decompiled with CFR 0.152.
 */
package jexx.compress;

import java.io.File;
import java.io.FileFilter;
import jexx.compress.ZipFile;
import jexx.io.FileUtil;
import jexx.util.Assert;

public class ZipUtil {
    public static File zip(String srcFile, String compressedFile, FileFilter fileFilter) {
        ZipFile zipFile = new ZipFile();
        zipFile.appendDirAndChildren(srcFile, fileFilter);
        return zipFile.zip(compressedFile);
    }

    public static File compressZip(String srcFile, String compressedFile) {
        return ZipUtil.zip(srcFile, compressedFile, null);
    }

    public static File zip(File srcFile, File compressedFile, FileFilter fileFilter) {
        ZipFile zipFile = new ZipFile();
        zipFile.appendDirAndChildren(srcFile, fileFilter);
        return zipFile.zip(compressedFile);
    }

    public static File zip(File srcFile, File compressedFile) {
        return ZipUtil.zip(srcFile, compressedFile, null);
    }

    public static File zip(String[] srcFiles, String compressedFile) {
        ZipFile zipFile = new ZipFile();
        for (String srcFile : srcFiles) {
            zipFile.appendDirAndChildren(srcFile);
        }
        return zipFile.zip(compressedFile);
    }

    public static File zip(File[] srcFiles, File compressedFile) {
        ZipFile zipFile = new ZipFile();
        for (File srcFile : srcFiles) {
            zipFile.appendDirAndChildren(srcFile);
        }
        return zipFile.zip(compressedFile);
    }

    public static void unzip(File zipFile, File outputDir) {
        Assert.isTrue(zipFile != null && zipFile.isFile(), "It's not a file!", new Object[0]);
        Assert.isTrue(outputDir != null && outputDir.isDirectory(), "It's not a dir!", new Object[0]);
        ZipFile zf = new ZipFile(zipFile);
        zf.unzip(outputDir);
    }

    public static void unzip(String zipFile, String outputDir) {
        ZipUtil.unzip(FileUtil.file(zipFile), FileUtil.file(outputDir));
    }
}

