/*
 * Decompiled with CFR 0.152.
 */
package jexx.compress;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import jexx.compress.AbstractZipFile;
import jexx.compress.ZipFileEntry;
import jexx.exception.IORuntimeException;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.lang.Charsets;
import jexx.util.CollectionUtil;
import jexx.util.StringUtil;

public class ZipFile
extends AbstractZipFile<ZipInputStream, ZipOutputStream> {
    public ZipFile() {
    }

    public ZipFile(File zipFile) {
        super(zipFile);
    }

    public ZipFile(URL zipURL) {
        super(zipURL);
    }

    public ZipFile(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    protected List<ZipFileEntry> doScanEntry(InputStream inputStream) {
        ArrayList<ZipFileEntry> arrayList;
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream, Charsets.UTF_8);
            ArrayList<ZipFileEntry> zipFileEntries = new ArrayList<ZipFileEntry>();
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipFileEntry zipFileEntry = new ZipFileEntry();
                zipFileEntry.setOriginName(zipEntry.getName());
                zipFileEntry.setName(zipEntry.getName());
                zipFileEntry.setDir(zipEntry.isDirectory());
                zipFileEntries.add(zipFileEntry);
                zipInputStream.closeEntry();
            }
            arrayList = zipFileEntries;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(zipInputStream);
                throw throwable;
            }
        }
        IOUtil.closeQuietly((Closeable)zipInputStream);
        return arrayList;
    }

    @Override
    protected ZipInputStream getZipInputStream(InputStream inputStream) {
        return new ZipInputStream(inputStream, Charsets.UTF_8);
    }

    @Override
    protected ZipOutputStream getZipOutputStream(File compressedFile) throws IOException {
        return new ZipOutputStream(new FileOutputStream(compressedFile));
    }

    @Override
    protected void doZipBase(ZipInputStream inputStream, ZipOutputStream outputStream, List<ZipFileEntry> baseZipFileEntries) throws IOException {
        ZipEntry zipEntry;
        Map<String, List<ZipFileEntry>> zipFileEntryMapWithOld = baseZipFileEntries.stream().filter(s -> !s.isAppend()).collect(Collectors.groupingBy(ZipFileEntry::getOriginName));
        while ((zipEntry = inputStream.getNextEntry()) != null) {
            List<ZipFileEntry> zipFileEntries = zipFileEntryMapWithOld.get(zipEntry.getName());
            if (CollectionUtil.isNotEmpty(zipFileEntries)) {
                if (zipFileEntries.size() == 1) {
                    ZipFileEntry zipFileEntry = zipFileEntries.get(0);
                    this.createEntry(zipFileEntry, outputStream);
                    if (!zipFileEntry.isDir()) {
                        IOUtil.copy(inputStream, (OutputStream)outputStream);
                    }
                    outputStream.closeEntry();
                } else {
                    byte[] bytes = IOUtil.readBytes(inputStream);
                    for (ZipFileEntry zipFileEntry : zipFileEntries) {
                        this.createEntry(zipFileEntry, outputStream);
                        if (!zipFileEntry.isDir()) {
                            outputStream.write(bytes);
                        }
                        outputStream.closeEntry();
                    }
                }
            }
            inputStream.closeEntry();
        }
    }

    @Override
    protected void doZipAppend(InputStream inputStream, ZipOutputStream outputStream, ZipFileEntry zipFileEntry) throws IOException {
        this.createEntry(zipFileEntry, outputStream);
        if (!zipFileEntry.isDir()) {
            IOUtil.copy(inputStream, (OutputStream)outputStream);
        }
        outputStream.closeEntry();
    }

    private void createEntry(ZipFileEntry zipFileEntry, ZipOutputStream outputStream) throws IOException {
        String name = zipFileEntry.getName();
        if (zipFileEntry.isDir() && !StringUtil.endWith(zipFileEntry.getName(), "/")) {
            name = name.concat("/");
        }
        outputStream.putNextEntry(new ZipEntry(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnzipBase(ZipInputStream inputStream, List<ZipFileEntry> baseZipFileEntries, String dir) throws IOException {
        Map<String, List<ZipFileEntry>> zipFileEntryMapWithOld = baseZipFileEntries.stream().filter(s -> !s.isAppend()).collect(Collectors.groupingBy(ZipFileEntry::getOriginName));
        try {
            ZipEntry zipEntry;
            while ((zipEntry = inputStream.getNextEntry()) != null) {
                List<ZipFileEntry> zipFileEntries = zipFileEntryMapWithOld.get(zipEntry.getName());
                if (CollectionUtil.isNotEmpty(zipFileEntries)) {
                    if (zipFileEntries.size() == 1) {
                        ZipFileEntry zipFileEntry = zipFileEntries.get(0);
                        File file = FileUtil.file(dir, zipFileEntry.getName());
                        if (zipEntry.isDirectory()) {
                            FileUtil.mkdirs(file);
                        } else {
                            FileUtil.mkdirs(file.getParent());
                            FileUtil.write(file, inputStream);
                        }
                    } else {
                        byte[] bytes = IOUtil.readBytes(inputStream);
                        for (ZipFileEntry entry : zipFileEntries) {
                            File file = FileUtil.file(dir, entry.getName());
                            if (zipEntry.isDirectory()) {
                                FileUtil.mkdirs(file);
                                continue;
                            }
                            FileUtil.mkdirs(file.getParent());
                            FileUtil.write(file, bytes);
                        }
                    }
                }
                inputStream.closeEntry();
            }
        }
        finally {
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    @Override
    protected void doUnzipAppend(InputStream inputStream, ZipFileEntry zipFileEntry, String dir) throws IOException {
        File file = FileUtil.file(dir, zipFileEntry.getName());
        if (zipFileEntry.isDir()) {
            FileUtil.mkdirs(file);
        } else {
            FileUtil.mkdirs(file.getParent());
            FileUtil.write(file, inputStream);
        }
    }
}

