/*
 * Decompiled with CFR 0.152.
 */
package jexx.compress;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import jexx.compress.ZipFileEntry;
import jexx.exception.IORuntimeException;
import jexx.exception.UtilException;
import jexx.io.FileNameUtil;
import jexx.io.FileUtil;
import jexx.io.IOUtil;
import jexx.util.Assert;
import jexx.util.StringUtil;

public abstract class AbstractZipFile<I extends InputStream, O extends OutputStream> {
    public static final int ZIP_FILE = 1;
    public static final int ZIP_URL = 2;
    public static final int ZIP_BYTES = 3;
    private int baseZipMode = 0;
    private File baseZipFile;
    private URL baseZipURL;
    private byte[] baseZipBytes;
    private final List<ZipFileEntry> baseZipEntries = new ArrayList<ZipFileEntry>();
    private final Map<String, ZipFileEntry> zipFileEntries = new HashMap<String, ZipFileEntry>();

    public AbstractZipFile() {
    }

    public AbstractZipFile(File zipFile) {
        Objects.requireNonNull(zipFile);
        if (!zipFile.exists()) {
            throw new IORuntimeException("file[{}] not exist!", zipFile.getName());
        }
        this.baseZipMode = 1;
        this.baseZipFile = zipFile;
        this.scanEntry(FileUtil.newBufferedInputStream(zipFile));
    }

    public AbstractZipFile(URL zipURL) {
        Objects.requireNonNull(zipURL);
        this.baseZipMode = 2;
        this.baseZipURL = zipURL;
        try {
            this.scanEntry(zipURL.openStream());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public AbstractZipFile(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        try {
            this.baseZipMode = 3;
            this.baseZipBytes = IOUtil.readBytes(inputStream);
        }
        finally {
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    protected InputStream getBaseZipInputStream() throws IOException {
        if (this.baseZipMode == 1) {
            return FileUtil.newBufferedInputStream(this.baseZipFile);
        }
        if (this.baseZipMode == 2) {
            return this.baseZipURL.openStream();
        }
        if (this.baseZipMode == 3) {
            return new ByteArrayInputStream(this.baseZipBytes);
        }
        return null;
    }

    protected InputStream getInputStreamOfAppendEntry(String appendEntryName) throws IOException {
        InputStream inputStream;
        ZipFileEntry entry = this.zipFileEntries.get(appendEntryName);
        if (entry == null || entry.isDir() || !entry.isAppend()) {
            return null;
        }
        if (entry.getAppendMode() == 1) {
            inputStream = FileUtil.newBufferedInputStream(entry.getAppendFile());
        } else if (entry.getAppendMode() == 2) {
            inputStream = entry.getAppendUrl().openStream();
        } else if (entry.getAppendMode() == 3) {
            inputStream = new ByteArrayInputStream(entry.getAppendBytes());
        } else {
            throw new UtilException("no support mode={}", entry.getAppendMode());
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanEntry(InputStream inputStream) {
        try {
            List<ZipFileEntry> entries = this.doScanEntry(inputStream);
            for (ZipFileEntry entry : entries) {
                this.zipFileEntries.put(entry.getName(), entry);
                this.baseZipEntries.add(entry.clone());
            }
        }
        finally {
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    protected List<ZipFileEntry> getZipFileEntry() {
        return new ArrayList<ZipFileEntry>(this.zipFileEntries.values());
    }

    public List<ZipFileEntry> getBaseZipEntries() {
        return this.baseZipEntries;
    }

    public ZipFileEntry getEntryByName(String name) {
        for (ZipFileEntry entry : this.baseZipEntries) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    protected abstract List<ZipFileEntry> doScanEntry(InputStream var1);

    public void move(String srcName, String toName) {
        this.checkEntryNotExist(toName);
        ZipFileEntry entry = this.checkEntryExist(srcName);
        this.zipFileEntries.remove(srcName);
        entry.setName(toName);
        this.zipFileEntries.put(toName, entry);
    }

    public void copy(String srcName, String toName) {
        this.checkEntryNotExist(toName);
        ZipFileEntry entry = this.checkEntryExist(srcName);
        ZipFileEntry zipFileEntry = entry.clone();
        zipFileEntry.setOriginName(entry.getOriginName());
        zipFileEntry.setName(toName);
        if (entry.isAppend()) {
            zipFileEntry.setAppend(true);
            zipFileEntry.setAppendFile(entry.getAppendFile());
        }
        this.zipFileEntries.put(toName, zipFileEntry);
    }

    public void delete(String srcName) {
        this.checkEntryExist(srcName);
        this.zipFileEntries.remove(srcName);
    }

    public void append(File file, String toName) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(StringUtil.format("File[{}] is not a file!", file.getPath()));
        }
        this.checkEntryNotExist(toName);
        ZipFileEntry zipFileEntry = new ZipFileEntry();
        zipFileEntry.setOriginName(toName);
        zipFileEntry.setName(toName);
        zipFileEntry.setAppend(true);
        zipFileEntry.setAppendMode(1);
        zipFileEntry.setAppendFile(file);
        this.zipFileEntries.put(toName, zipFileEntry);
    }

    public void append(URL url, String toName) {
        Objects.requireNonNull(url);
        this.checkEntryNotExist(toName);
        ZipFileEntry zipFileEntry = new ZipFileEntry();
        zipFileEntry.setOriginName(toName);
        zipFileEntry.setName(toName);
        zipFileEntry.setAppend(true);
        zipFileEntry.setAppendMode(2);
        zipFileEntry.setAppendUrl(url);
        this.zipFileEntries.put(toName, zipFileEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(InputStream inputStream, String toName) {
        Objects.requireNonNull(inputStream);
        this.checkEntryNotExist(toName);
        try {
            byte[] bytes = IOUtil.readBytes(inputStream);
            this.append(bytes, toName);
        }
        finally {
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    public void append(byte[] bytes, String toName) {
        Assert.notEmpty(bytes, "bytes not empty!", new Object[0]);
        this.checkEntryNotExist(toName);
        ZipFileEntry zipFileEntry = new ZipFileEntry();
        zipFileEntry.setOriginName(toName);
        zipFileEntry.setName(toName);
        zipFileEntry.setAppend(true);
        zipFileEntry.setAppendMode(3);
        zipFileEntry.setAppendBytes(bytes);
        this.zipFileEntries.put(toName, zipFileEntry);
    }

    public void appendDir(String dirName) {
        if (!StringUtil.endWith(dirName, "/")) {
            dirName = dirName.concat("/");
        }
        ZipFileEntry zipFileEntry = new ZipFileEntry();
        zipFileEntry.setOriginName(dirName);
        zipFileEntry.setName(dirName);
        zipFileEntry.setDir(true);
        zipFileEntry.setAppend(true);
        this.zipFileEntries.put(dirName, zipFileEntry);
    }

    public void appendDirAndChildren(File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File[{}] is not a dir!");
        }
        String parentName = FileNameUtil.getParentName(dir.getPath());
        this._appendDirAndChildren(dir, parentName, filter);
    }

    public void appendDirAndChildren(File dir) {
        this.appendDirAndChildren(dir, null);
    }

    public void appendDirAndChildren(String dir, FileFilter filter) {
        this.appendDirAndChildren(FileUtil.file(dir), filter);
    }

    public void appendDirAndChildren(String dir) {
        this.appendDirAndChildren(dir, null);
    }

    private void _appendDirAndChildren(File file, String rootDir, FileFilter filter) {
        if (filter != null && !filter.accept(file)) {
            return;
        }
        String subPath = FileNameUtil.relativePath(file.getPath(), rootDir);
        if (file.isDirectory()) {
            this.appendDir(subPath);
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    this._appendDirAndChildren(child, rootDir, filter);
                }
            }
        } else if (file.isFile()) {
            this.append(file, subPath);
        }
    }

    protected abstract I getZipInputStream(InputStream var1) throws IOException;

    protected abstract O getZipOutputStream(File var1) throws IOException;

    public final File zip(File outputFile) {
        InputStream inputStream = null;
        I zipInputStream = null;
        O zipOutputStream = null;
        try {
            List<ZipFileEntry> zipFileEntries;
            inputStream = this.getBaseZipInputStream();
            zipOutputStream = this.getZipOutputStream(outputFile);
            if (inputStream != null) {
                zipInputStream = this.getZipInputStream(inputStream);
                zipFileEntries = this.getZipFileEntry().stream().filter(s -> !s.isAppend()).collect(Collectors.toList());
                this.doZipBase(zipInputStream, zipOutputStream, zipFileEntries);
                IOUtil.closeQuietly(new Closeable[]{inputStream, zipInputStream});
            }
            zipFileEntries = this.getZipFileEntry().stream().filter(ZipFileEntry::isAppend).collect(Collectors.toList());
            for (ZipFileEntry zipFileEntry : zipFileEntries) {
                if (!zipFileEntry.isAppend()) continue;
                inputStream = this.getInputStreamOfAppendEntry(zipFileEntry.getName());
                this.doZipAppend(inputStream, zipOutputStream, zipFileEntry);
                IOUtil.closeQuietly((Closeable)inputStream);
            }
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(new Closeable[]{inputStream, zipInputStream, zipOutputStream});
                throw throwable;
            }
        }
        IOUtil.closeQuietly(new Closeable[]{inputStream, zipInputStream, zipOutputStream});
        return outputFile;
    }

    public final File zip(String outputFile) {
        return this.zip(FileUtil.file(outputFile));
    }

    protected abstract void doZipBase(I var1, O var2, List<ZipFileEntry> var3) throws IOException;

    protected abstract void doZipAppend(InputStream var1, O var2, ZipFileEntry var3) throws IOException;

    public final void unzip(File outputDir) {
        InputStream inputStream = null;
        I zipInputStream = null;
        String dir = outputDir.getPath();
        try {
            List<ZipFileEntry> zipFileEntries;
            inputStream = this.getBaseZipInputStream();
            if (inputStream != null) {
                zipInputStream = this.getZipInputStream(inputStream);
                zipFileEntries = this.getZipFileEntry().stream().filter(s -> !s.isAppend()).collect(Collectors.toList());
                this.doUnzipBase(zipInputStream, zipFileEntries, dir);
                IOUtil.closeQuietly(new Closeable[]{inputStream, zipInputStream});
            }
            zipFileEntries = this.getZipFileEntry().stream().filter(ZipFileEntry::isAppend).collect(Collectors.toList());
            for (ZipFileEntry zipFileEntry : zipFileEntries) {
                if (!zipFileEntry.isAppend() || (inputStream = this.getInputStreamOfAppendEntry(zipFileEntry.getName())) == null) continue;
                this.doUnzipAppend(inputStream, zipFileEntry, dir);
                IOUtil.closeQuietly((Closeable)inputStream);
            }
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(new Closeable[]{inputStream, zipInputStream});
                throw throwable;
            }
        }
        IOUtil.closeQuietly(new Closeable[]{inputStream, zipInputStream});
    }

    public final void unzip(String outputDir) {
        this.unzip(FileUtil.file(outputDir));
    }

    protected abstract void doUnzipBase(I var1, List<ZipFileEntry> var2, String var3) throws IOException;

    protected abstract void doUnzipAppend(InputStream var1, ZipFileEntry var2, String var3) throws IOException;

    private ZipFileEntry checkEntryExist(String name) {
        ZipFileEntry entry = this.zipFileEntries.get(name);
        if (entry == null) {
            throw new IllegalArgumentException(StringUtil.format("{} not exist in zip!", name));
        }
        return entry;
    }

    private void checkEntryNotExist(String name) {
        ZipFileEntry entry = this.zipFileEntries.get(name);
        if (entry != null) {
            throw new IllegalArgumentException(StringUtil.format("{} exist in zip!", name));
        }
    }
}

