/*
 * Decompiled with CFR 0.152.
 */
package jexx.collect;

import java.util.Map;
import jexx.collect.LinkedStringKeyMap;

public interface StringKeyMap
extends Map<String, Object> {
    default public Boolean getBoolean(String key) {
        return this.getBoolean(key, true);
    }

    default public Boolean getBoolean(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, Boolean.class, exceptionIfTypeNotMatch);
    }

    default public Byte getByte(String key) {
        return this.getByte(key, true);
    }

    default public Byte getByte(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, Byte.class, exceptionIfTypeNotMatch);
    }

    default public Character getCharacter(String key) {
        return this.getCharacter(key, true);
    }

    default public Character getCharacter(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, Character.class, exceptionIfTypeNotMatch);
    }

    default public Short getShort(String key) {
        return this.getShort(key, true);
    }

    default public Short getShort(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, Short.class, exceptionIfTypeNotMatch);
    }

    default public Integer getInteger(String key) {
        return this.getInteger(key, true);
    }

    default public Integer getInteger(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, Integer.class, exceptionIfTypeNotMatch);
    }

    default public Long getLong(String key) {
        return this.getLong(key, true);
    }

    default public Long getLong(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, Long.class, exceptionIfTypeNotMatch);
    }

    default public Double getDouble(String key) {
        return this.getDouble(key, true);
    }

    default public Double getDouble(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, Double.class, exceptionIfTypeNotMatch);
    }

    default public String getString(String key) {
        return this.getString(key, true);
    }

    default public String getString(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, String.class, exceptionIfTypeNotMatch);
    }

    default public StringKeyMap getStringKeyMap(String key) {
        return this.getStringKeyMap(key, true);
    }

    default public StringKeyMap getStringKeyMap(String key, boolean exceptionIfTypeNotMatch) {
        return this.getObject(key, LinkedStringKeyMap.class, exceptionIfTypeNotMatch);
    }

    default public <T> T getObject(String key, Class<T> clazz) {
        return this.getObject(key, clazz, true);
    }

    default public <T> T getObject(String key, Class<T> clazz, boolean exceptionIfTypeNotMatch) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (clazz.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (clazz.equals(LinkedStringKeyMap.class) && value instanceof Map) {
            return (T)new LinkedStringKeyMap((Map)value);
        }
        if (exceptionIfTypeNotMatch) {
            throw new ClassCastException(value.getClass() + " cannot cast " + clazz + ", key=" + key);
        }
        return null;
    }
}

