/*
 * Decompiled with CFR 0.152.
 */
package jexx.collect;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import jexx.collect.AbstractTable;
import jexx.collect.Table;

class StandardTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    private final Map<Table.Key<R, C>, V> dataMap;

    StandardTable(Map<Table.Key<R, C>, V> dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new CellIterator();
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        Table.Key<R, C> key = this.createKey(rowKey, columnKey);
        return this.dataMap.put(key, value);
    }

    @Override
    public int size() {
        return this.dataMap != null ? this.dataMap.size() : 0;
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<Table.Key<R, C>, V>> cellIterator;

        private CellIterator() {
            this.cellIterator = StandardTable.this.dataMap.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.cellIterator.hasNext();
        }

        @Override
        public Table.Cell<R, C, V> next() {
            Map.Entry entry = this.cellIterator.next();
            if (entry != null) {
                Table.Key key = entry.getKey();
                return new AbstractTable.SimpleCell(key, entry.getValue());
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            this.cellIterator.remove();
        }
    }
}

