/*
 * Decompiled with CFR 0.152.
 */
package jexx.collect;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.SortedSet;
import jexx.collect.BoundType;
import jexx.collect.Cut;
import jexx.collect.DiscreteDomain;
import jexx.util.Assert;
import jexx.util.IterableUtil;

public class Range<C extends Comparable>
implements Serializable {
    final Cut<C> lowerBound;
    final Cut<C> upperBound;

    private Range(Cut<C> lowerBound, Cut<C> upperBound) {
        Objects.requireNonNull(lowerBound, "lowerBound must be not null");
        Objects.requireNonNull(upperBound, "upperBound must be not null");
        if (lowerBound.compareTo(upperBound) > 0 || lowerBound == Cut.aboveAll() || upperBound == Cut.belowAll()) {
            throw new IllegalArgumentException("Invalid range: " + this.toString(lowerBound, upperBound));
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    static <C extends Comparable<?>> Range<C> create(Cut<C> lowerBound, Cut<C> upperBound) {
        return new Range<C>(lowerBound, upperBound);
    }

    public static <C extends Comparable<?>> Range<C> open(C lower, C upper) {
        return Range.create(Cut.aboveValue(lower), Cut.belowValue(upper));
    }

    public static <C extends Comparable<?>> Range<C> closed(C lower, C upper) {
        return Range.create(Cut.belowValue(lower), Cut.aboveValue(upper));
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C lower, C upper) {
        return Range.create(Cut.belowValue(lower), Cut.belowValue(upper));
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C lower, C upper) {
        return Range.create(Cut.aboveValue(lower), Cut.aboveValue(upper));
    }

    public static <C extends Comparable<?>> Range<C> range(C lower, BoundType lowerType, C upper, BoundType upperType) {
        Objects.requireNonNull(lowerType);
        Objects.requireNonNull(upperType);
        Cut<C> lowerBound = lowerType == BoundType.OPEN ? Cut.aboveValue(lower) : Cut.belowValue(lower);
        Cut<C> upperBound = upperType == BoundType.OPEN ? Cut.belowValue(upper) : Cut.aboveValue(upper);
        return Range.create(lowerBound, upperBound);
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C endpoint) {
        return Range.create(Cut.belowAll(), Cut.belowValue(endpoint));
    }

    public static <C extends Comparable<?>> Range<C> atMost(C endpoint) {
        return Range.create(Cut.belowAll(), Cut.aboveValue(endpoint));
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C endpoint) {
        return Range.create(Cut.aboveValue(endpoint), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C endpoint) {
        return Range.create(Cut.belowValue(endpoint), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> singleton(C value) {
        return Range.closed(value, value);
    }

    public boolean hasLowerBound() {
        return this.lowerBound != Cut.belowAll();
    }

    public C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public boolean hasUpperBound() {
        return this.upperBound != Cut.aboveAll();
    }

    public C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public Range<C> canonical(DiscreteDomain<C> domain) {
        Objects.requireNonNull(domain, "domain must be not null");
        Cut<C> lower = this.lowerBound.canonical(domain);
        Cut<C> upper = this.upperBound.canonical(domain);
        return lower == this.lowerBound && upper == this.upperBound ? this : Range.create(lower, upper);
    }

    public boolean contains(C value) {
        Objects.requireNonNull(value, "value must be not null");
        return this.lowerBound.isLessThan(value) && !this.upperBound.isLessThan(value);
    }

    public boolean containsAll(Iterable<? extends C> values) {
        if (IterableUtil.isEmpty(values)) {
            return true;
        }
        for (Comparable value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    private <T> SortedSet<T> cast(Iterable<T> iterable) {
        return (SortedSet)iterable;
    }

    public Iterator<C> iterator(DiscreteDomain<C> domain) {
        return new RangeIterator<C>(this, domain);
    }

    public boolean equals(Object object) {
        if (object instanceof Range) {
            Range other = (Range)object;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return this.toString(this.lowerBound, this.upperBound);
    }

    private String toString(Cut<?> lowerBound, Cut<?> upperBound) {
        StringBuilder sb = new StringBuilder(16);
        lowerBound.describeAsLowerBound(sb);
        sb.append(",");
        upperBound.describeAsUpperBound(sb);
        return sb.toString();
    }

    private static class RangeIterator<C extends Comparable>
    implements Iterator<C> {
        private Range<C> range;
        private DiscreteDomain<C> domain;
        private C current;
        private C next;

        public RangeIterator(Range<C> range, DiscreteDomain<C> domain) {
            this.range = range.canonical(domain);
            this.domain = domain;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                Object n;
                if (this.current == null) {
                    n = this.range.lowerBound.endpoint;
                } else {
                    n = this.domain.next(this.current);
                    if (this.range.upperBound.isLessThan(n)) {
                        return false;
                    }
                }
                this.next = n;
            }
            return this.next != null;
        }

        @Override
        public C next() {
            Assert.notNull(this.next, "please use hasNext", new Object[0]);
            this.current = this.next;
            this.next = null;
            return this.current;
        }
    }
}

