/*
 * Decompiled with CFR 0.152.
 */
package jexx.collect;

import java.io.Serializable;
import java.util.NoSuchElementException;

public abstract class DiscreteDomain<C extends Comparable> {
    protected DiscreteDomain() {
    }

    public static DiscreteDomain<Short> shorts() {
        return ShortDomain.INSTANCE;
    }

    public static DiscreteDomain<Integer> integers() {
        return IntegerDomain.INSTANCE;
    }

    public static DiscreteDomain<Long> longs() {
        return LongDomain.INSTANCE;
    }

    public static DiscreteDomain<Character> chars() {
        return CharacterDomain.INSTANCE;
    }

    public abstract C next(C var1);

    public abstract C previous(C var1);

    public C maxValue() {
        throw new NoSuchElementException();
    }

    public C minValue() {
        throw new NoSuchElementException();
    }

    private static final class CharacterDomain
    extends DiscreteDomain<Character>
    implements Serializable {
        private static final CharacterDomain INSTANCE = new CharacterDomain();

        private CharacterDomain() {
        }

        @Override
        public Character next(Character value) {
            char v = value.charValue();
            return v == '\uffff' ? null : Character.valueOf((char)(v + '\u0001'));
        }

        @Override
        public Character previous(Character value) {
            char v = value.charValue();
            return v == '\u0000' ? null : Character.valueOf((char)(v - '\u0001'));
        }

        @Override
        public Character maxValue() {
            return Character.valueOf('\uffff');
        }

        @Override
        public Character minValue() {
            return Character.valueOf('\u0000');
        }
    }

    private static final class ShortDomain
    extends DiscreteDomain<Short>
    implements Serializable {
        private static final ShortDomain INSTANCE = new ShortDomain();

        private ShortDomain() {
        }

        @Override
        public Short next(Short value) {
            short v = value;
            return v == Short.MAX_VALUE ? null : Short.valueOf((short)(v + 1));
        }

        @Override
        public Short previous(Short value) {
            short v = value;
            return v == Short.MIN_VALUE ? null : Short.valueOf((short)(v - 1));
        }

        @Override
        public Short maxValue() {
            return (short)Short.MAX_VALUE;
        }

        @Override
        public Short minValue() {
            return (short)Short.MIN_VALUE;
        }
    }

    private static final class IntegerDomain
    extends DiscreteDomain<Integer>
    implements Serializable {
        private static final IntegerDomain INSTANCE = new IntegerDomain();

        private IntegerDomain() {
        }

        @Override
        public Integer next(Integer value) {
            int v = value;
            return v == Integer.MAX_VALUE ? null : Integer.valueOf(v + 1);
        }

        @Override
        public Integer previous(Integer value) {
            int v = value;
            return v == Integer.MIN_VALUE ? null : Integer.valueOf(v - 1);
        }

        @Override
        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Integer minValue() {
            return Integer.MIN_VALUE;
        }
    }

    private static final class LongDomain
    extends DiscreteDomain<Long>
    implements Serializable {
        private static final LongDomain INSTANCE = new LongDomain();

        private LongDomain() {
        }

        @Override
        public Long next(Long value) {
            long v = value;
            return v == Long.MAX_VALUE ? null : Long.valueOf(v + 1L);
        }

        @Override
        public Long previous(Long value) {
            long v = value;
            return v == Long.MIN_VALUE ? null : Long.valueOf(v - 1L);
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }
    }
}

