/*
 * Decompiled with CFR 0.152.
 */
package jexx.collect;

import java.io.Serializable;
import java.util.NoSuchElementException;
import jexx.collect.BoundType;
import jexx.collect.DiscreteDomain;

abstract class Cut<C extends Comparable>
implements Comparable<Cut<C>>,
Serializable {
    private static final long serialVersionUID = 0L;
    final C endpoint;

    Cut(C endpoint) {
        this.endpoint = endpoint;
    }

    C endpoint() {
        return this.endpoint;
    }

    abstract boolean isLessThan(C var1);

    abstract BoundType typeAsLowerBound();

    abstract BoundType typeAsUpperBound();

    abstract void describeAsLowerBound(StringBuilder var1);

    abstract void describeAsUpperBound(StringBuilder var1);

    Cut<C> canonical(DiscreteDomain<C> domain) {
        return this;
    }

    @Override
    public int compareTo(Cut<C> that) {
        if (that == Cut.belowAll()) {
            return 1;
        }
        if (that == Cut.aboveAll()) {
            return -1;
        }
        int result = Cut.compareOrThrow(this.endpoint, that.endpoint);
        if (result != 0) {
            return result;
        }
        return Boolean.compare(this instanceof AboveValue, that instanceof AboveValue);
    }

    static int compareOrThrow(Comparable left, Comparable right) {
        return left.compareTo(right);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Cut) {
            Cut that = (Cut)obj;
            try {
                int compareResult = this.compareTo(that);
                return compareResult == 0;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    static <C extends Comparable> Cut<C> belowAll() {
        return BelowAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> aboveAll() {
        return AboveAll.INSTANCE;
    }

    static <C extends Comparable> Cut<C> belowValue(C endpoint) {
        return new BelowValue<C>(endpoint);
    }

    static <C extends Comparable> Cut<C> aboveValue(C endpoint) {
        return new AboveValue<C>(endpoint);
    }

    private static final class AboveValue<C extends Comparable>
    extends Cut<C> {
        public AboveValue(C endpoint) {
            super(endpoint);
        }

        @Override
        boolean isLessThan(C value) {
            return AboveValue.compareOrThrow(this.endpoint, value) < 0;
        }

        @Override
        BoundType typeAsLowerBound() {
            return BoundType.OPEN;
        }

        @Override
        BoundType typeAsUpperBound() {
            return BoundType.CLOSED;
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append("(").append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append("]");
        }

        @Override
        Cut<C> canonical(DiscreteDomain<C> domain) {
            Comparable next = domain.next(this.endpoint);
            return next != null ? AboveValue.belowValue(next) : Cut.aboveAll();
        }
    }

    private static final class BelowValue<C extends Comparable>
    extends Cut<C> {
        public BelowValue(C endpoint) {
            super(endpoint);
        }

        @Override
        boolean isLessThan(C value) {
            return BelowValue.compareOrThrow(this.endpoint, value) <= 0;
        }

        @Override
        BoundType typeAsLowerBound() {
            return BoundType.CLOSED;
        }

        @Override
        BoundType typeAsUpperBound() {
            return BoundType.OPEN;
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append("[").append(this.endpoint);
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append(this.endpoint).append(")");
        }
    }

    private static final class AboveAll
    extends Cut<Comparable<?>> {
        private static final AboveAll INSTANCE = new AboveAll();

        public AboveAll() {
            super(null);
        }

        @Override
        boolean isLessThan(Comparable<?> value) {
            return false;
        }

        @Override
        BoundType typeAsLowerBound() {
            throw new IllegalStateException();
        }

        @Override
        BoundType typeAsUpperBound() {
            throw new IllegalStateException();
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            sb.append("+").append("\u221e").append(")");
        }

        @Override
        public int compareTo(Cut<Comparable<?>> that) {
            return that == this ? 0 : 1;
        }
    }

    private static final class BelowAll
    extends Cut<Comparable<?>> {
        private static final BelowAll INSTANCE = new BelowAll();

        public BelowAll() {
            super(null);
        }

        @Override
        boolean isLessThan(Comparable<?> value) {
            return true;
        }

        @Override
        BoundType typeAsLowerBound() {
            throw new IllegalStateException();
        }

        @Override
        BoundType typeAsUpperBound() {
            throw new IllegalStateException();
        }

        @Override
        void describeAsLowerBound(StringBuilder sb) {
            sb.append("(-").append("\u221e");
        }

        @Override
        void describeAsUpperBound(StringBuilder sb) {
            throw new AssertionError();
        }

        @Override
        public int compareTo(Cut<Comparable<?>> that) {
            return that == this ? 0 : -1;
        }

        @Override
        Cut<Comparable<?>> canonical(DiscreteDomain<Comparable<?>> domain) {
            try {
                return Cut.belowValue(domain.minValue());
            }
            catch (NoSuchElementException e) {
                return this;
            }
        }
    }
}

