/*
 * Decompiled with CFR 0.152.
 */
package jexx.collect;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import jexx.collect.AbstractTable;
import jexx.collect.Table;
import jexx.util.Assert;
import jexx.util.CollectionUtil;

public class ArrayTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    private List<R> rowKeys;
    private List<C> columnKeys;
    private final Map<R, Integer> rowKeyToIndex;
    private final Map<C, Integer> columnKeyToIndex;
    private final V[][] array;
    private final Map<V, List<Table.Key<R, C>>> valueMap;

    public ArrayTable(List<? extends R> rowKeys, List<? extends C> columnKeys) {
        Assert.notEmpty(rowKeys);
        Assert.notEmpty(columnKeys);
        this.rowKeys = Collections.unmodifiableList(rowKeys);
        this.columnKeys = Collections.unmodifiableList(columnKeys);
        this.rowKeyToIndex = ArrayTable.index(rowKeys);
        this.columnKeyToIndex = ArrayTable.index(columnKeys);
        this.array = new Object[rowKeys.size()][columnKeys.size()];
        this.eraseAll();
        this.valueMap = new HashMap<V, List<Table.Key<R, C>>>(this.rowKeys.size() * this.columnKeys.size());
    }

    private static <E> Map<E, Integer> index(List<? extends E> list) {
        HashMap<E, Integer> map = new HashMap<E, Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            map.put(list.get(i), i);
        }
        return map;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object rowKey, Object columnKey) {
        return this.containsRowKey(rowKey) && this.containsColumnKey(columnKey);
    }

    @Override
    public boolean containsRowKey(Object rowKey) {
        return this.rowKeyToIndex.containsKey(rowKey);
    }

    @Override
    public boolean containsColumnKey(Object columnKey) {
        return this.columnKeyToIndex.containsKey(columnKey);
    }

    @Override
    public boolean containsValue(Object value) {
        List<Table.Key<R, C>> list = this.valueMap.get(value);
        return CollectionUtil.isNotEmpty(list);
    }

    public V at(int rowIndex, int columnIndex) {
        Assert.isTrue(rowIndex > -1, "rowKey not exist", new Object[0]);
        Assert.isTrue(columnIndex > -1, "columnKey not exist", new Object[0]);
        return this.array[rowIndex][columnIndex];
    }

    @Override
    public V get(Object rowKey, Object columnKey) {
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        return rowIndex == null || columnIndex == null ? null : (V)this.at(rowIndex, columnIndex);
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        Integer rowIndex = this.rowKeyToIndex.get(rowKey);
        Assert.isTrue(rowIndex != null && rowIndex > -1, "rowKey={} not exist", rowKey);
        Integer columnIndex = this.columnKeyToIndex.get(columnKey);
        Assert.isTrue(columnIndex != null && columnIndex > -1, "columnKey={} not exist", columnKey);
        this.array[rowIndex.intValue()][columnIndex.intValue()] = value;
        return value;
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        super.putAll(table);
    }

    public V set(int rowIndex, int columnIndex, V value) {
        Assert.isTrue(rowIndex < this.rowKeys.size(), "rowIndex is out of row key", new Object[0]);
        Assert.isTrue(columnIndex < this.columnKeys.size(), "columnIndex is out of column key", new Object[0]);
        V oldValue = this.array[rowIndex][columnIndex];
        this.array[rowIndex][columnIndex] = value;
        return oldValue;
    }

    @Override
    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new ListIterator<Table.Cell<R, C, V>>(){
            private final int size;
            private int position;
            {
                this.size = ArrayTable.this.size();
            }

            @Override
            public boolean hasNext() {
                return this.position < this.size;
            }

            @Override
            public Table.Cell<R, C, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.get(this.position++);
            }

            @Override
            public boolean hasPrevious() {
                return this.position > 0;
            }

            @Override
            public Table.Cell<R, C, V> previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.get(this.position--);
            }

            @Override
            public int nextIndex() {
                return this.position + 1;
            }

            @Override
            public int previousIndex() {
                return this.position - 1;
            }

            protected Table.Cell<R, C, V> get(int index) {
                int rowIndex = index / ArrayTable.this.columnKeys.size();
                int columnIndex = index % ArrayTable.this.columnKeys.size();
                return new AbstractTable.SimpleCell(ArrayTable.this.rowKeys.get(rowIndex), ArrayTable.this.columnKeys.get(columnIndex), ArrayTable.this.at(rowIndex, columnIndex));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Table.Cell<R, C, V> rcvCell) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Table.Cell<R, C, V> rcvCell) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Table.Cell<R, C, V>> toColumnIterator(R rowKey) {
        final int rowIndex = this.rowKeyToIndex.get(rowKey);
        if (rowIndex >= this.rowKeys.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new ListIterator<Table.Cell<R, C, V>>(){
            private final int size;
            private int position;
            {
                this.size = ArrayTable.this.array[rowIndex].length;
            }

            @Override
            public boolean hasNext() {
                return this.position < this.size;
            }

            @Override
            public Table.Cell<R, C, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.get(this.position++);
            }

            @Override
            public boolean hasPrevious() {
                return this.position > 0;
            }

            @Override
            public Table.Cell<R, C, V> previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.get(this.position--);
            }

            @Override
            public int nextIndex() {
                return this.position + 1;
            }

            @Override
            public int previousIndex() {
                return this.position - 1;
            }

            protected Table.Cell<R, C, V> get(int index) {
                return new AbstractTable.SimpleCell(ArrayTable.this.rowKeys.get(rowIndex), ArrayTable.this.columnKeys.get(index), ArrayTable.this.at(rowIndex, index));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Table.Cell<R, C, V> rcvCell) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Table.Cell<R, C, V> rcvCell) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Table.Cell<R, C, V>> toRowIterator(C columnKey) {
        final int columnIndex = this.columnKeyToIndex.get(columnKey);
        if (columnIndex >= this.columnKeys.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new ListIterator<Table.Cell<R, C, V>>(){
            private final int size;
            private int position;
            {
                this.size = ArrayTable.this.array.length;
            }

            @Override
            public boolean hasNext() {
                return this.position < this.size;
            }

            @Override
            public Table.Cell<R, C, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.get(this.position++);
            }

            @Override
            public boolean hasPrevious() {
                return this.position > 0;
            }

            @Override
            public Table.Cell<R, C, V> previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.get(this.position--);
            }

            @Override
            public int nextIndex() {
                return this.position + 1;
            }

            @Override
            public int previousIndex() {
                return this.position - 1;
            }

            protected Table.Cell<R, C, V> get(int index) {
                return new AbstractTable.SimpleCell(ArrayTable.this.rowKeys.get(index), ArrayTable.this.columnKeys.get(columnIndex), ArrayTable.this.at(index, columnIndex));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Table.Cell<R, C, V> rcvCell) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Table.Cell<R, C, V> rcvCell) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.rowKeys.size() * this.columnKeys.size();
    }

    @Override
    public V remove(Object rowKey, Object columnKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.eraseAll();
    }

    public void eraseAll() {
        for (Object[] objectArray : this.array) {
            Arrays.fill(objectArray, null);
        }
    }
}

