/*
 * Decompiled with CFR 0.152.
 */
package jexx.collect;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import jexx.collect.Table;

abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    private transient Collection<V> values;

    protected AbstractTable() {
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object rowKey, Object columnKey) {
        Iterator<Table.Cell<R, C, V>> i = this.cellSet().iterator();
        if (i.hasNext()) {
            Table.Cell<R, C, V> e = i.next();
            return this.eq(rowKey, e.getKey().getRowKey()) && this.eq(columnKey, e.getKey().getColumnKey());
        }
        return false;
    }

    private boolean eq(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    @Override
    public boolean containsRowKey(Object rowKey) {
        Iterator<Table.Cell<R, C, V>> i = this.cellSet().iterator();
        if (i.hasNext()) {
            Table.Cell<R, C, V> e = i.next();
            return this.eq(rowKey, e.getKey().getRowKey());
        }
        return false;
    }

    @Override
    public boolean containsColumnKey(Object columnKey) {
        Iterator<Table.Cell<R, C, V>> i = this.cellSet().iterator();
        if (i.hasNext()) {
            Table.Cell<R, C, V> e = i.next();
            return this.eq(columnKey, e.getKey().getColumnKey());
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Table.Cell<R, C, V>> i = this.cellSet().iterator();
        if (value == null) {
            while (i.hasNext()) {
                Table.Cell<R, C, V> e = i.next();
                if (e.getValue() != null) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                Table.Cell<R, C, V> e = i.next();
                if (!value.equals(e.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    protected Table.Key<R, C> createKey(R rowKey, C columnKey) {
        return new SimpleKey<R, C>(rowKey, columnKey);
    }

    @Override
    public V get(Object rowKey, Object columnKey) {
        for (Table.Cell<R, C, V> e : this.cellSet()) {
            if (!this.eq(rowKey, e.getKey().getRowKey()) || !this.eq(columnKey, e.getKey().getColumnKey())) continue;
            return e.getValue();
        }
        return null;
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell<R, C, V> cell : table.cellSet()) {
            Table.Key<R, C> key = cell.getKey();
            this.put(key.getRowKey(), key.getColumnKey(), cell.getValue());
        }
    }

    @Override
    public V remove(Object rowKey, Object columnKey) {
        Iterator<Table.Cell<R, C, V>> i = this.cellSet().iterator();
        V oldValue = null;
        Iterator<Table.Cell<R, C, V>> iterator = this.cellSet().iterator();
        while (i.hasNext()) {
            Table.Cell<R, C, V> cell = iterator.next();
            if (!this.eq(rowKey, cell.getKey().getRowKey()) || !this.eq(columnKey, cell.getKey().getColumnKey())) continue;
            i.remove();
            oldValue = cell.getValue();
        }
        return oldValue;
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        return this.createCellSet();
    }

    Set<Table.Cell<R, C, V>> createCellSet() {
        return new CellSet();
    }

    abstract Iterator<Table.Cell<R, C, V>> cellIterator();

    @Override
    public Collection<V> values() {
        AbstractCollection result = this.values;
        if (result == null) {
            this.values = result = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<Table.Cell<R, C, V>> i;
                        {
                            this.i = AbstractTable.this.cellSet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractTable.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractTable.this.isEmpty();
                }

                @Override
                public void clear() {
                    AbstractTable.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return AbstractTable.this.containsValue(v);
                }
            };
        }
        return result;
    }

    @Override
    public void clear() {
        this.cellSet().clear();
    }

    public int hashCode() {
        int h = 0;
        for (Table.Cell<R, C, V> cell : this.cellSet()) {
            h += cell.hashCode();
        }
        return h;
    }

    public String toString() {
        Iterator<Table.Cell<R, C, V>> i = this.cellSet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Table.Cell<R, C, V> e = i.next();
            Table.Key<R, C> key = e.getKey();
            R rowKey = key.getRowKey();
            C columnKey = key.getColumnKey();
            V value = e.getValue();
            sb.append("(");
            sb.append((Object)(rowKey == this ? "null" : rowKey));
            sb.append(",");
            sb.append((Object)(columnKey == this ? "null" : columnKey));
            sb.append(")=");
            sb.append((Object)(value == this ? "null" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        CellSet() {
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)o;
                Object value = AbstractTable.this.get(cell.getKey().getRowKey(), cell.getKey().getColumnKey());
                return value != null && value.equals(cell.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)o;
                AbstractTable.this.remove(cell.getKey().getRowKey(), cell.getKey().getColumnKey());
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            AbstractTable.this.clear();
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return AbstractTable.this.cellIterator();
        }

        @Override
        public int size() {
            return AbstractTable.this.size();
        }
    }

    public static class SimpleCell<R, C, V>
    implements Table.Cell<R, C, V>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Table.Key<R, C> key;
        private final V value;

        public SimpleCell(R rowKey, C columnKey, V value) {
            this.key = new SimpleKey<R, C>(rowKey, columnKey);
            this.value = value;
        }

        public SimpleCell(Table.Key<R, C> key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleCell(Table.Cell<R, C, V> cell) {
            this.key = cell.getKey();
            this.value = cell.getValue();
        }

        @Override
        public Table.Key<R, C> getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Table.Cell that = (Table.Cell)o;
            return Objects.equals(this.key, that.getKey()) && Objects.equals(this.value, that.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }

    public static class SimpleKey<R, C>
    implements Table.Key<R, C>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final R rowKey;
        private final C columnKey;

        public SimpleKey(R rowKey, C columnKey) {
            this.rowKey = rowKey;
            this.columnKey = columnKey;
        }

        @Override
        public R getRowKey() {
            return this.rowKey;
        }

        @Override
        public C getColumnKey() {
            return this.columnKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Table.Key simpleKey = (Table.Key)o;
            return Objects.equals(this.rowKey, simpleKey.getRowKey()) && Objects.equals(this.columnKey, simpleKey.getColumnKey());
        }

        public int hashCode() {
            return Objects.hash(this.rowKey, this.columnKey);
        }
    }
}

