/*
 * Decompiled with CFR 0.152.
 */
package jexx.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.StampedLock;
import jexx.cache.Cache;

public abstract class AbstractCacheMap<K, V>
implements Cache<K, V> {
    protected Map<K, CacheObject<K, V>> cacheMap;
    private final StampedLock lock = new StampedLock();
    protected int cacheSize;
    protected long timeout;
    protected boolean existCustomTimeout;
    protected int hitCount;
    protected int missCount;

    @Override
    public int limit() {
        return this.cacheSize;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V object, long timeout) {
        Objects.requireNonNull(object);
        long stamp = this.lock.writeLock();
        try {
            CacheObject<K, V> co = new CacheObject<K, V>(key, object, timeout);
            if (timeout != 0L) {
                this.existCustomTimeout = true;
            }
            if (this.isReallyFull(key)) {
                this.pruneCache();
            }
            this.cacheMap.put(key, co);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public int getMissCount() {
        return this.missCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        long stamp = this.lock.readLock();
        try {
            CacheObject<K, V> co = this.cacheMap.get(key);
            if (co == null) {
                ++this.missCount;
                V v = null;
                return v;
            }
            if (co.isExpired()) {
                long newStamp = this.lock.tryConvertToWriteLock(stamp);
                if (newStamp != 0L) {
                    stamp = newStamp;
                } else {
                    this.lock.unlockRead(stamp);
                    stamp = this.lock.writeLock();
                }
                CacheObject<K, V> removedCo = this.cacheMap.remove(key);
                if (removedCo != null) {
                    this.onRemove(removedCo.key, removedCo.cachedObject);
                }
                ++this.missCount;
                V v = null;
                return v;
            }
            ++this.hitCount;
            V v = co.getObject();
            return v;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    protected abstract int pruneCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int prune() {
        long stamp = this.lock.writeLock();
        try {
            int n = this.pruneCache();
            return n;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public boolean isFull() {
        if (this.cacheSize == 0) {
            return false;
        }
        return this.cacheMap.size() >= this.cacheSize;
    }

    protected boolean isReallyFull(K key) {
        if (this.cacheSize == 0) {
            return false;
        }
        if (this.cacheMap.size() >= this.cacheSize) {
            return !this.cacheMap.containsKey(key);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        V removedValue = null;
        long stamp = this.lock.writeLock();
        try {
            CacheObject<K, V> co = this.cacheMap.remove(key);
            if (co != null) {
                this.onRemove(co.key, co.cachedObject);
                removedValue = (V)co.cachedObject;
            }
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        return removedValue;
    }

    @Override
    public void clear() {
        long stamp = this.lock.writeLock();
        try {
            this.cacheMap.clear();
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> snapshot() {
        long stamp = this.lock.writeLock();
        try {
            HashMap map = new HashMap(this.cacheMap.size());
            this.cacheMap.forEach((key, cacheValue) -> map.put(key, cacheValue.getObject()));
            HashMap hashMap = map;
            return hashMap;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    protected void onRemove(K key, V cachedObject) {
    }

    class CacheObject<K2, V2> {
        final K2 key;
        final V2 cachedObject;
        long lastAccess;
        long accessCount;
        long ttl;

        CacheObject(K2 key, V2 object, long ttl) {
            this.key = key;
            this.cachedObject = object;
            this.ttl = ttl;
            this.lastAccess = System.currentTimeMillis();
        }

        boolean isExpired() {
            if (this.ttl == 0L) {
                return false;
            }
            return this.lastAccess + this.ttl < System.currentTimeMillis();
        }

        V2 getObject() {
            this.lastAccess = System.currentTimeMillis();
            ++this.accessCount;
            return this.cachedObject;
        }
    }
}

