/*
 * Decompiled with CFR 0.152.
 */
package jexx.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum BasicType {
    BYTE,
    SHORT,
    INT,
    INTEGER,
    LONG,
    DOUBLE,
    FLOAT,
    BOOLEAN,
    CHAR,
    CHARACTER,
    STRING;

    private static final Map<Class<?>, Class<?>> wrapperPrimitiveMap;
    public static final Map<Class<?>, Class<?>> primitiveWrapperMap;
    private static final Map<String, Class<?>> primitiveTypeNameMap;

    public static boolean isWrapperPrimitiveClass(Class<?> clazz) {
        return wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isPrimitiveClass(Class<?> clazz) {
        return primitiveWrapperMap.containsKey(clazz);
    }

    public static Class<?> getPrimitiveTypeByClassname(String name) {
        return primitiveTypeNameMap.get(name);
    }

    public static Class<?> wrap(Class<?> clazz) {
        if (null == clazz || !clazz.isPrimitive()) {
            return clazz;
        }
        Class<?> result = primitiveWrapperMap.get(clazz);
        return null == result ? clazz : result;
    }

    public static Class<?> unWrap(Class<?> clazz) {
        if (null == clazz || clazz.isPrimitive()) {
            return clazz;
        }
        Class<?> result = wrapperPrimitiveMap.get(clazz);
        return null == result ? clazz : result;
    }

    static {
        wrapperPrimitiveMap = new ConcurrentHashMap(8);
        primitiveWrapperMap = new ConcurrentHashMap(8);
        primitiveTypeNameMap = new HashMap(16);
        wrapperPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperPrimitiveMap.put(Void.class, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry : wrapperPrimitiveMap.entrySet()) {
            primitiveWrapperMap.put(entry.getValue(), entry.getKey());
        }
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(wrapperPrimitiveMap.values());
        Collections.addAll(primitiveTypes, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
    }
}

