package jexx.collect;

import java.util.Map;

/**
 * key为字符串类型的map; 常用于 json 反序列化时使用
 * @author jeff
 * @since 2021-02-27
 */
public interface StringKeyMap extends Map<String, Object> {

    default Byte getByte(String key){
        return getByte(key, true);
    }

    default Byte getByte(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, Byte.class, exceptionIfTypeNotMatch);
    }

    default Character getCharacter(String key){
        return getCharacter(key, true);
    }

    default Character getCharacter(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, Character.class, exceptionIfTypeNotMatch);
    }

    default Short getShort(String key){
        return getShort(key, true);
    }

    default Short getShort(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, Short.class, exceptionIfTypeNotMatch);
    }

    default Integer getInteger(String key){
        return getInteger(key, true);
    }

    default Integer getInteger(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, Integer.class, exceptionIfTypeNotMatch);
    }

    default Long getLong(String key){
        return getLong(key, true);
    }

    default Long getLong(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, Long.class, exceptionIfTypeNotMatch);
    }

    default Double getDouble(String key){
        return getDouble(key, true);
    }

    default Double getDouble(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, Double.class, exceptionIfTypeNotMatch);
    }

    default String getString(String key){
        return getString(key, true);
    }

    default String getString(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, String.class, exceptionIfTypeNotMatch);
    }

    default StringKeyMap getStringKeyMap(String key){
        return getStringKeyMap(key, true);
    }

    default StringKeyMap getStringKeyMap(String key, boolean exceptionIfTypeNotMatch){
        return getObject(key, LinkedStringKeyMap.class, exceptionIfTypeNotMatch);
    }

    default <T> T getObject(String key, Class<T> clazz){
        return getObject(key, clazz, true);
    }

    /**
     * 获取指定类型的值
     * @param key key
     * @param clazz 值类型
     * @param exceptionIfTypeNotMatch 类型不匹配是否抛出异常
     * @param <T> 值泛型
     * @return 值
     */
    @SuppressWarnings("unchecked")
    default <T> T getObject(String key, Class<T> clazz, boolean exceptionIfTypeNotMatch){
        Object value = get(key);
        if(value == null){
            return null;
        }

        if(clazz.isAssignableFrom(value.getClass())){
            return  (T) value;
        }

        if(clazz.equals(LinkedStringKeyMap.class) && value instanceof Map){
            return (T)new LinkedStringKeyMap((Map<?,?>) value);
        }

        if(exceptionIfTypeNotMatch){
            throw new ClassCastException(value.getClass() +" cannot cast "+clazz+", key="+key);
        }
        return null;
    }

}
