package jexx.time;

import jexx.exception.UtilException;

import java.util.Calendar;

/**
 * 日期时间单位
 */
public enum DateUnit {
    /** 一毫秒 */
    MS(1),
    /** 一秒的毫秒数 */
    SECOND(1000),
    /**一分钟的毫秒数 */
    MINUTE(SECOND.getMillis() * 60),
    /**一小时的毫秒数 */
    HOUR(MINUTE.getMillis() * 60),
    /**一天的毫秒数 */
    DAY(HOUR.getMillis() * 24),
    /**一周的毫秒数 */
    WEEK(DAY.getMillis() * 7),
    MONTH(-1),
    YEAR(-1)
    ;

    private long millis;
    DateUnit(long millis){
        this.millis = millis;
    }

    public int getFieldInCalendar(){
        int field = -1;
        switch (this){
            case MS:
                field = Calendar.MILLISECOND;
                break;
            case SECOND:
                field = Calendar.SECOND;
                break;
            case MINUTE:
                field = Calendar.MINUTE;
                break;
            case HOUR:
                field = Calendar.HOUR;
                break;
            case DAY:
                field = Calendar.DATE;
                break;
            case WEEK:
                field = Calendar.WEEK_OF_YEAR;
                break;
            case MONTH:
                field = Calendar.MONTH;
                break;
            case YEAR:
                field = Calendar.YEAR;
                break;
            default:
                throw new UtilException("unhandle DateUnit:{}", this);
        }
        return field;
    }

    public long getMillis(){
        return this.millis;
    }
}
