/*
 * Decompiled with CFR 0.152.
 */
package jexx.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import jexx.bean.AbstractBeanPropertyAccessor;
import jexx.bean.BeanUtil;
import jexx.bean.CachedIntrospectionResults;
import jexx.bean.DyBean;
import jexx.convert.Convert;
import jexx.util.Assert;
import jexx.util.MapUtil;
import jexx.util.ReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DyBeanImpl
extends AbstractBeanPropertyAccessor
implements DyBean {
    private static final Logger LOG = LoggerFactory.getLogger(DyBeanImpl.class);
    protected CachedIntrospectionResults cachedIntrospectionResults;

    @Override
    protected AbstractBeanPropertyAccessor newNestedPropertyAccessor(Object object, String nestedPath) {
        DyBeanImpl dyBean = new DyBeanImpl();
        dyBean.setWrappedInstance(object, nestedPath, this.getWrappedInstance());
        dyBean.setAllowCollectionAutoGrow(this.allowCollectionAutoGrow);
        dyBean.setAllowCreateHoldValueIfNull(this.allowCreateHoldValueIfNull);
        return dyBean;
    }

    protected CachedIntrospectionResults getCachedIntrospectionResults() {
        if (this.cachedIntrospectionResults == null) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(this.getWrappedClass());
        }
        return this.cachedIntrospectionResults;
    }

    @Override
    public void setWrappedInstance(Object object) {
        Assert.isTrue((object != null && BeanUtil.isBean(object.getClass()) ? 1 : 0) != 0, (String)"object must be a bean", (Object[])new Object[0]);
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Map<String, Object> object) {
        MapBean bean = new MapBean(object);
        this.setWrappedInstance(bean, "", null);
    }

    @Override
    public boolean isReadableProperty(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getCachedIntrospectionResults().getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            LOG.debug("propertyName \"{}\" not found!", (Object)propertyName);
        }
        return propertyDescriptor != null && propertyDescriptor.getReadMethod() != null;
    }

    @Override
    public boolean isWritableProperty(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getCachedIntrospectionResults().getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            LOG.debug("propertyName \"{}\" not found!", (Object)propertyName);
        }
        return propertyDescriptor != null && propertyDescriptor.getWriteMethod() != null;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.getCachedIntrospectionResults().getPropertyDescriptors();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.getCachedIntrospectionResults().getPropertyDescriptor(propertyName);
    }

    @Override
    protected AbstractBeanPropertyAccessor.PropertyHandle getPropertyHandle(String propertyName) {
        PropertyDescriptor propertyDescriptor = this.getCachedIntrospectionResults().getPropertyDescriptor(propertyName);
        if (propertyDescriptor == null) {
            return null;
        }
        return new BeanPropertyHandle(propertyDescriptor);
    }

    public boolean isMap() {
        return this.getWrappedInstance() instanceof Map;
    }

    private class MapBean {
        private Map<String, Object> $;

        public MapBean(Map<String, Object> $) {
            this.$ = $;
        }

        public Map<String, Object> get$() {
            return this.$;
        }

        public void set$(Map<String, Object> $) {
            this.$ = $;
        }
    }

    protected class BeanPropertyHandle
    extends AbstractBeanPropertyAccessor.PropertyHandle {
        private PropertyDescriptor propertyDescriptor;

        public BeanPropertyHandle(PropertyDescriptor propertyDescriptor) {
            super(propertyDescriptor.getName(), propertyDescriptor.getReadMethod() != null, propertyDescriptor.getWriteMethod() != null);
            this.propertyDescriptor = propertyDescriptor;
        }

        @Override
        public Object getValue() throws Exception {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            ReflectUtil.makeAccessible((Method)readMethod);
            Object wrappedObject = DyBeanImpl.this.getWrappedInstance();
            return readMethod.invoke(wrappedObject, (Object[])null);
        }

        @Override
        public Class<?> getPropertyType() {
            return this.propertyDescriptor.getPropertyType();
        }

        @Override
        public Class<?> getCollectionType(int nestingLevel) {
            return this.getNestedType(nestingLevel);
        }

        @Override
        public Class<?> getMapKeyType(int nestingLevel) {
            return this.getNestedType(nestingLevel, MapUtil.toMap((Object)nestingLevel, (Object)0));
        }

        @Override
        public Class<?> getMapValueType(int nestingLevel) {
            return this.getNestedType(nestingLevel, MapUtil.toMap((Object)nestingLevel, (Object)1));
        }

        @Override
        public void setValue(Object value) throws Exception {
            Method writeMethod = this.propertyDescriptor.getWriteMethod();
            Class<?>[] parameterTypes = writeMethod.getParameterTypes();
            ReflectUtil.makeAccessible((Method)writeMethod);
            writeMethod.invoke(DyBeanImpl.this.getWrappedInstance(), Convert.convert(parameterTypes[0], (Object)value));
        }

        @Override
        protected Class<?> getNestedType(int nestingLevel, Map<Integer, Integer> typeIndexesPerLevel) {
            Method readMethod = this.propertyDescriptor.getReadMethod();
            Type type = readMethod.getGenericReturnType();
            Class<?> clazz = type.getClass();
            for (int i = 1; i <= nestingLevel; ++i) {
                if (clazz.isArray()) {
                    type = clazz.getComponentType();
                    continue;
                }
                if (!(type instanceof ParameterizedType)) continue;
                Type[] types = ((ParameterizedType)type).getActualTypeArguments();
                Integer index = typeIndexesPerLevel != null ? typeIndexesPerLevel.get(i) : null;
                index = index == null ? types.length - 1 : index;
                type = types[index];
            }
            return this.resolveClass(type);
        }
    }
}

