/*
 * Decompiled with CFR 0.152.
 */
package jexx.bean;

import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jexx.bean.CachedIntrospectionResults;
import jexx.bean.DyBean;
import jexx.bean.DyBeanFactory;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.ReflectUtil;

public class BeanUtil {
    public static boolean isBean(Class<?> clazz) {
        return CachedIntrospectionResults.forClass(clazz).isBean();
    }

    public static BeanInfo getBeanInfo(Class<?> cla) {
        return CachedIntrospectionResults.forClass(cla).getBeanInfo();
    }

    public static <T> T toBean(Class<T> cla, Map<String, Object> map) {
        return BeanUtil.toBean(cla, map, new IBeanConsumer(){

            @Override
            public String transferKey(String fieldName) {
                return fieldName;
            }

            @Override
            public Object transferValue(Object value) {
                return value;
            }
        });
    }

    public static <T> T toBean(Class<T> clazz, Map<String, Object> map, IBeanConsumer consumer) {
        Assert.isTrue((boolean)BeanUtil.isBean(clazz), (String)"{} is not a bean!", (Object[])new Object[]{clazz});
        Object obj = ReflectUtil.newInstance(clazz, (Object[])new Object[0]);
        DyBean bean = DyBeanFactory.createDyBean(obj, false, false);
        map.forEach((k, v) -> {
            Object value;
            String key = consumer != null ? consumer.transferKey((String)k) : k;
            Object object = value = consumer != null ? consumer.transferValue(v) : v;
            if (bean.isWritableProperty(key)) {
                bean.setPropertyValue(key, value);
            }
        });
        return (T)obj;
    }

    public static <T> List<T> toBeans(Class<T> clazz, List<Map<String, Object>> rows) {
        return BeanUtil.toBeans(clazz, rows, null);
    }

    public static <T> List<T> toBeans(Class<T> clazz, List<Map<String, Object>> rows, IBeanConsumer consumer) {
        Assert.isTrue((boolean)BeanUtil.isBean(clazz), (String)"Class \"{}\" is not bean!", (Object[])new Object[]{clazz});
        if (CollectionUtil.isEmpty(rows)) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (Map<String, Object> data : rows) {
            list.add(BeanUtil.toBean(clazz, data, consumer));
        }
        return list;
    }

    public static Map<String, Object> toMap(Object obj) {
        HashMap<String, Object> targetMap = new HashMap<String, Object>();
        return BeanUtil.toMap(obj, targetMap);
    }

    public static Map<String, Object> toMap(Object obj, Map<String, Object> targetMap) {
        PropertyDescriptor[] propertyDescriptors;
        if (obj instanceof Map) {
            targetMap.putAll((Map)obj);
            return targetMap;
        }
        Assert.isTrue((boolean)BeanUtil.isBean(obj.getClass()), (String)"obj is not a map or a bean!", (Object[])new Object[0]);
        DyBean bean = DyBeanFactory.createDyBean(obj, false, false);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = bean.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            if ("class".equals(name)) continue;
            targetMap.put(name, bean.getPropertyValue(name));
        }
        return targetMap;
    }

    public static Object getFieldValue(Object bean, String fieldName) {
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldName);
        }
        return ReflectUtil.getFieldValue((Object)bean, (String)fieldName);
    }

    public static interface IBeanConsumer {
        public String transferKey(String var1);

        public Object transferValue(Object var1);
    }
}

