/*
 * Decompiled with CFR 0.152.
 */
package jexx.bean;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jexx.bean.BeanException;
import jexx.bean.IndexProperty;
import jexx.bean.PropertyAccessor;
import jexx.convert.Convert;
import jexx.exception.UtilException;
import jexx.util.ArrayUtil;
import jexx.util.Assert;
import jexx.util.CollectionUtil;
import jexx.util.MapUtil;
import jexx.util.ObjectUtil;
import jexx.util.ReflectUtil;
import jexx.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBeanPropertyAccessor
implements PropertyAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBeanPropertyAccessor.class);
    private String nestedPath = "";
    private Object wrappedObject;
    private Object rootObject;
    protected boolean allowCollectionAutoGrow = true;
    protected boolean allowCreateHoldValueIfNull = true;

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        this.wrappedObject = ObjectUtil.unwrapOptional((Object)object);
        Assert.notNull((Object)this.wrappedObject, (String)"Target object must not be null", (Object[])new Object[0]);
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !this.nestedPath.isEmpty() ? rootObject : this.wrappedObject;
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public final Object getWrappedInstance() {
        Assert.isTrue((this.wrappedObject != null ? 1 : 0) != 0, (String)"No wrapped object", (Object[])new Object[0]);
        return this.wrappedObject;
    }

    public final Class<?> getWrappedClass() {
        return this.getWrappedInstance().getClass();
    }

    public final String getNestedPath() {
        return this.nestedPath;
    }

    public final Object getRootInstance() {
        Assert.isTrue((this.rootObject != null ? 1 : 0) != 0, (String)"No root object", (Object[])new Object[0]);
        return this.rootObject;
    }

    public final Class<?> getRootClass() {
        return this.getRootInstance().getClass();
    }

    public void setAllowCollectionAutoGrow(boolean allowCollectionAutoGrow) {
        this.allowCollectionAutoGrow = allowCollectionAutoGrow;
    }

    public void setAllowCreateHoldValueIfNull(boolean allowCreateHoldValueIfNull) {
        this.allowCreateHoldValueIfNull = allowCreateHoldValueIfNull;
    }

    public Object getPropertyValue(String propertyName) {
        int index = propertyName.indexOf(".");
        if (index > -1) {
            String nestedProperty = propertyName.substring(0, index);
            AbstractBeanPropertyAccessor accessor = this.getNestedPropertyAccessor(nestedProperty);
            return accessor.getPropertyValue(propertyName.substring(index + 1));
        }
        PropertyToken token = this.getPropertyNameToken(propertyName);
        return this.getPropertyValue(token);
    }

    protected Object getPropertyValue(PropertyToken token) {
        String propertyName = token.canonicalName;
        String actual = token.actualName;
        PropertyHandle handle = this.getPropertyHandle(actual);
        if (handle == null || !handle.isRead()) {
            throw new BeanException(StringUtil.format((String)"Class[{}] cannot read property {}", (Object[])new Object[]{this.getRootClass(), actual}));
        }
        try {
            Object value = handle.getValue();
            if (token.keys != null) {
                StringBuilder indexedPropertyName = new StringBuilder(token.actualName);
                for (int i = 0; i < token.keys.length; ++i) {
                    String key = token.keys[i];
                    if (value == null) {
                        throw new BeanException("Cannot read index property \"{}\" because key \"{}\" is null ", propertyName, indexedPropertyName.toString());
                    }
                    if (value.getClass().isArray()) {
                        int index = Integer.parseInt(key);
                        value = this.growArrayIfNecessary(value, index, indexedPropertyName.toString());
                        value = Array.get(value, index);
                    } else if (value instanceof List) {
                        List list = (List)value;
                        int index = Integer.parseInt(key);
                        this.growCollectionIfNecessary(list, index, indexedPropertyName.toString(), handle, i + 1);
                        value = list.get(index);
                    } else if (value instanceof Set) {
                        Set set = (Set)value;
                        int index = Integer.parseInt(key);
                        this.growCollectionIfNecessary(set, index, indexedPropertyName.toString(), handle, i + 1);
                        if (index < 0 || index >= set.size()) {
                            throw new BeanException("Cannot get element {} from set because the set's size is {}, path={}", index, set.size(), indexedPropertyName);
                        }
                        Iterator it = set.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            Object elem = it.next();
                            if (j == index) {
                                value = elem;
                                break;
                            }
                            ++j;
                        }
                    } else if (value instanceof Map) {
                        Map map = (Map)value;
                        Class<?> paramType = handle.getMapKeyType(i + 1);
                        Object convertedMapKey = this.convertIfNecessary(key, paramType);
                        value = map.get(convertedMapKey);
                    } else {
                        throw new IllegalArgumentException(StringUtil.format((String)"key {} is not illegal", (Object[])new Object[0]));
                    }
                    indexedPropertyName.append("[").append(key).append("]");
                }
            }
            return value;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    public List<IndexProperty> getIndexPropertyValues(String propertyName) {
        ArrayList<IndexProperty> indexProperties = new ArrayList<IndexProperty>();
        indexProperties.add(new IndexProperty(this.nestedPath, this.wrappedObject));
        return this.getIndexPropertyValues(propertyName, indexProperties);
    }

    public Map<String, Object> getMapIndexPropertyValues(String propertyName) {
        List<IndexProperty> indexProperties = this.getIndexPropertyValues(propertyName);
        return indexProperties.stream().collect(Collectors.toMap(IndexProperty::getPath, IndexProperty::getValue));
    }

    protected List<IndexProperty> getIndexPropertyValues(String propertyName, List<IndexProperty> indexProperties) {
        int index = propertyName.indexOf(".");
        if (index > -1) {
            String nestedProperty = propertyName.substring(0, index);
            try {
                ArrayList<IndexProperty> newList = new ArrayList<IndexProperty>();
                for (IndexProperty property : indexProperties) {
                    AbstractBeanPropertyAccessor accessor = this.newNestedPropertyAccessor(property.getValue(), property.getPath());
                    List<IndexProperty> m1 = accessor.getIndexPropertyValues(nestedProperty);
                    newList.addAll(m1);
                }
                return this.getIndexPropertyValues(propertyName.substring(index + 1), newList);
            }
            catch (Exception e) {
                throw new BeanException(e);
            }
        }
        PropertyToken token = this.getPropertyNameToken(propertyName);
        ArrayList<IndexProperty> newList = new ArrayList<IndexProperty>();
        for (IndexProperty property : indexProperties) {
            this.scanPropertyMapValue(newList, property.getPath(), property.getValue(), token, 0);
        }
        return newList;
    }

    protected List<IndexProperty> scanPropertyMapValue(List<IndexProperty> all, String rootPath, Object holdingObject, PropertyToken token, int keyLocation) {
        if (holdingObject == null) {
            if (ArrayUtil.isEmpty((Object[])token.keys) || token.keys.length == keyLocation - 1) {
                String path = StringUtil.isEmpty((CharSequence)rootPath) ? "" : rootPath.concat(".");
                all.add(new IndexProperty(path.concat(token.getPath()), null));
                return all;
            }
            return all;
        }
        if (keyLocation == 0) {
            AbstractBeanPropertyAccessor accessor = this.newNestedPropertyAccessor(holdingObject, rootPath);
            Object value = accessor.getPropertyValue(token.actualName);
            return this.scanPropertyMapValue(all, rootPath, value, token, keyLocation + 1);
        }
        if (ArrayUtil.isEmpty((Object[])token.keys) || token.keys.length == keyLocation - 1) {
            String path = StringUtil.isEmpty((CharSequence)rootPath) ? "" : rootPath.concat(".");
            all.add(new IndexProperty(path.concat(token.getPath()), holdingObject));
            return all;
        }
        int keyIndex = keyLocation - 1;
        String key = token.keys[keyIndex];
        if (holdingObject.getClass().isArray()) {
            int length = Array.getLength(holdingObject);
            if ("".equals(key)) {
                for (int i = 0; i < length; ++i) {
                    Array.get(holdingObject, i);
                    PropertyToken newToken = token.clone();
                    newToken.keys[keyIndex] = Integer.toString(i);
                    this.scanPropertyMapValue(all, rootPath, Array.get(holdingObject, i), newToken, keyLocation + 1);
                }
            } else {
                int index = Integer.parseInt(key);
                if (index < 0 || index >= length) {
                    throw new BeanException("key {} is illegal", key);
                }
                PropertyToken newToken = token.clone();
                this.scanPropertyMapValue(all, rootPath, Array.get(holdingObject, index), newToken, keyLocation + 1);
            }
        } else if (holdingObject instanceof List) {
            int length = ((List)holdingObject).size();
            if ("".equals(key)) {
                for (int i = 0; i < length; ++i) {
                    PropertyToken newToken = token.clone();
                    newToken.keys[keyIndex] = Integer.toString(i);
                    this.scanPropertyMapValue(all, rootPath, ((List)holdingObject).get(i), newToken, keyLocation + 1);
                }
            } else {
                int index = Integer.parseInt(key);
                if (index < 0 || index >= length) {
                    throw new BeanException("key {} is illegal", key);
                }
                PropertyToken newToken = token.clone();
                this.scanPropertyMapValue(all, rootPath, Array.get(holdingObject, index), newToken, keyLocation + 1);
            }
        } else if (holdingObject instanceof Set) {
            Set set = (Set)holdingObject;
            int length = set.size();
            if ("".equals(key)) {
                Iterator it = set.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Object elem = it.next();
                    PropertyToken newToken = token.clone();
                    newToken.keys[keyIndex] = Integer.toString(i);
                    this.scanPropertyMapValue(all, rootPath, elem, newToken, keyLocation + 1);
                    ++i;
                }
            } else {
                int index = Integer.parseInt(key);
                if (index < 0 || index >= length) {
                    throw new BeanException("key {} is illegal", key);
                }
                Iterator it = set.iterator();
                int i = 0;
                while (it.hasNext()) {
                    if (i == index) {
                        Object elem = it.next();
                        PropertyToken newToken = token.clone();
                        newToken.keys[keyIndex] = Integer.toString(i);
                        this.scanPropertyMapValue(all, rootPath, elem, newToken, keyLocation + 1);
                        break;
                    }
                    ++i;
                }
            }
        } else if (holdingObject instanceof Map) {
            Map mValue = (Map)holdingObject;
            if ("".equals(key)) {
                for (Map.Entry entry : mValue.entrySet()) {
                    PropertyToken newToken = token.clone();
                    newToken.keys[keyIndex] = entry.getKey().toString();
                    this.scanPropertyMapValue(all, rootPath, entry.getValue(), newToken, keyLocation + 1);
                }
            } else {
                PropertyToken newToken = token.clone();
                this.scanPropertyMapValue(all, rootPath, mValue.get(key), newToken, keyLocation + 1);
            }
        }
        return all;
    }

    protected Object getPropertyHoldingValue(PropertyToken token) {
        PropertyToken holdingToken = this.getPropertyHoldingToken(token);
        return this.getPropertyValue(holdingToken);
    }

    protected PropertyToken getPropertyHoldingToken(PropertyToken token) {
        Assert.isTrue((token.keys != null ? 1 : 0) != 0, (String)"No token keys", (Object[])new Object[0]);
        String canonicalName = token.canonicalName;
        int lastIndex = canonicalName.lastIndexOf("[");
        canonicalName = canonicalName.substring(0, lastIndex);
        String[] keys = new String[token.keys.length - 1];
        System.arraycopy(token.keys, 0, keys, 0, token.keys.length - 1);
        PropertyToken holdingToken = new PropertyToken(token.actualName);
        holdingToken.canonicalName = canonicalName;
        holdingToken.keys = keys;
        return holdingToken;
    }

    private void ensurePropertyHoldingValueNotNull(PropertyToken token) {
        if (this.allowCreateHoldValueIfNull && token.keys != null) {
            try {
                PropertyHandle ph = this.getPropertyHandle(token.actualName);
                Object value = ph.getValue();
                if (value == null) {
                    value = this.newValue(ph.getPropertyType(), null, token.actualName);
                    ph.setValue(value);
                }
                StringBuilder indexedPropertyName = new StringBuilder(token.actualName);
                for (int i = 0; i < token.keys.length - 1; ++i) {
                    Object v;
                    String key = token.keys[i];
                    if (value.getClass().isArray()) {
                        int index = Integer.parseInt(key);
                        Object v2 = Array.get(value = this.growArrayIfNecessary(value, index, indexedPropertyName.toString()), index);
                        if (v2 == null) {
                            v2 = this.newValue(ph.getNestedType(i + 1), null, key);
                            Array.set(value, index, v2);
                        }
                        value = v2;
                    } else if (value instanceof List) {
                        List list = (List)value;
                        int index = Integer.parseInt(key);
                        this.growCollectionIfNecessary(list, index, indexedPropertyName.toString(), ph, i + 1);
                        v = list.get(index);
                        if (v == null) {
                            v = this.newValue(ph.getNestedType(i + 1), null, key);
                            Array.set(value, index, v);
                        }
                        value = v;
                    } else if (value instanceof Set) {
                        Set set = (Set)value;
                        int index = Integer.parseInt(key);
                        if (index < 0 || index >= set.size()) {
                            throw new BeanException(StringUtil.format((String)"property name {} key[{}] is big!", (Object[])new Object[]{indexedPropertyName, key}));
                        }
                        v = null;
                        Iterator it = set.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            Object elem = it.next();
                            if (j == index) {
                                v = elem;
                                break;
                            }
                            ++j;
                        }
                        if (v == null) {
                            v = this.newValue(ph.getNestedType(i + 1), null, key);
                            Array.set(value, index, v);
                        }
                        value = v;
                    } else if (value instanceof Map) {
                        Map map = (Map)value;
                        Class<?> paramType = ph.getMapKeyType(i + 1);
                        Object convertedMapKey = this.convertIfNecessary(key, paramType);
                        Object v3 = map.get(convertedMapKey);
                        if (v3 == null) {
                            v3 = this.newValue(ph.getMapValueType(i + 1), null, key);
                            map.put(convertedMapKey, v3);
                        }
                        value = v3;
                    } else {
                        throw new IllegalArgumentException(StringUtil.format((String)"key {} is not illegal", (Object[])new Object[0]));
                    }
                    indexedPropertyName.append("[").append(key).append("]");
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    public void setPropertyValue(String propertyName, Object value) {
        int index = propertyName.indexOf(".");
        if (index > -1) {
            String nestedProperty = propertyName.substring(0, index);
            AbstractBeanPropertyAccessor accessor = this.getNestedPropertyAccessor(nestedProperty);
            accessor.setPropertyValue(propertyName.substring(index + 1), value);
        } else {
            PropertyToken token = this.getPropertyNameToken(propertyName);
            this.setPropertyValue(token, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setPropertyValue(PropertyToken token, Object newValue) {
        PropertyHandle ph = this.getPropertyHandle(token.actualName);
        if (ph == null || !ph.isWrite()) {
            throw new BeanException("Class[{}] cannot write property {}", this.getWrappedClass(), token.actualName);
        }
        try {
            this.ensurePropertyHoldingValueNotNull(token);
            if (token.keys != null) {
                String lastKey = token.keys[token.keys.length - 1];
                PropertyToken holdingToken = this.getPropertyHoldingToken(token);
                Object holdingValue = this.getPropertyValue(holdingToken);
                if (holdingValue == null) {
                    throw new BeanException("Class[{}] cannot write index property {} because holding key {} is null ", this.getWrappedClass(), token.canonicalName, holdingToken.canonicalName);
                }
                if (holdingValue.getClass().isArray()) {
                    Class<?> requiredType = holdingValue.getClass().getComponentType();
                    int arrayIndex = Integer.parseInt(lastKey);
                    int length = Array.getLength(holdingValue);
                    if (this.allowCollectionAutoGrow && arrayIndex >= length) {
                        holdingValue = this.growArrayIfNecessary(holdingValue, arrayIndex, holdingToken.canonicalName);
                    }
                    Object convertValue = this.convertIfNecessary(newValue, requiredType);
                    Array.set(holdingValue, arrayIndex, convertValue);
                    return;
                } else if (holdingValue instanceof List) {
                    List list = (List)holdingValue;
                    Class<?> requiredType = ph.getNestedType(token.keys.length);
                    int arrayIndex = Integer.parseInt(lastKey);
                    if (this.allowCollectionAutoGrow && arrayIndex >= list.size()) {
                        for (int i = list.size(); i <= arrayIndex; ++i) {
                            if (i == arrayIndex) {
                                list.add(Convert.convert(requiredType, (Object)newValue));
                                continue;
                            }
                            list.add(this.newValue(requiredType, null, holdingToken.canonicalName));
                        }
                        return;
                    } else {
                        list.set(arrayIndex, Convert.convert(requiredType, (Object)newValue));
                    }
                    return;
                } else if (holdingValue instanceof Set) {
                    Set set = (Set)holdingValue;
                    int arrayIndex = Integer.parseInt(lastKey);
                    if (arrayIndex != set.size()) {
                        throw new BeanException("only add element for set of size {}, path={}", arrayIndex, set.size(), holdingToken.canonicalName);
                    }
                    Class<?> requiredType = ph.getNestedType(token.keys.length);
                    set.add(Convert.convert(requiredType, (Object)newValue));
                    return;
                } else {
                    if (!(holdingValue instanceof Map)) throw new IllegalArgumentException(StringUtil.format((String)"Class[{}] property {} is neither an array or a list or a map", (Object[])new Object[]{this.getWrappedClass(), holdingToken.canonicalName}));
                    Map map = (Map)holdingValue;
                    Class<?> keyType = ph.getMapKeyType(token.keys.length);
                    Object key = Convert.convert(keyType, (Object)lastKey);
                    Class<?> valueType = ph.getMapValueType(token.keys.length);
                    Object value = Convert.convert(valueType, (Object)newValue);
                    map.put(key, value);
                }
                return;
            } else {
                ph.setValue(newValue);
            }
            return;
        }
        catch (Exception e) {
            throw new BeanException(e);
        }
    }

    protected PropertyToken getPropertyNameToken(String propertyName) {
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).length() > 1 && key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        PropertyToken tokens = new PropertyToken(actualName != null ? actualName : propertyName);
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[".concat(StringUtil.join(keys, (String)"][")).concat("]");
            tokens.keys = ArrayUtil.toStringArray(keys);
        }
        return tokens;
    }

    protected abstract PropertyHandle getPropertyHandle(String var1);

    private Object convertIfNecessary(Object value, Type type) {
        return Convert.convert((Type)type, (Object)value);
    }

    private Object growArrayIfNecessary(Object array, int index, String name) {
        int length = Array.getLength(array);
        if (this.allowCollectionAutoGrow && index >= length) {
            Class<?> componentType = array.getClass().getComponentType();
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(array, 0, newArray, 0, length);
            this.setPropertyValue(name, newArray);
            return newArray;
        }
        return array;
    }

    private Collection<Object> growCollectionIfNecessary(Collection<Object> collection, int index, String name, PropertyHandle pd, int nestingLevel) {
        Class<?> elementType;
        int size = collection.size();
        if (this.allowCollectionAutoGrow && index >= size && (elementType = pd.getNestedType(nestingLevel)) != null) {
            for (int i = size; i <= index; ++i) {
                collection.add(this.newValue(elementType, null, name));
            }
        }
        return collection;
    }

    private Object newValue(Class<?> type, Class<?> elementType, String name) {
        try {
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (componentType.isArray()) {
                    Object array = Array.newInstance(componentType, 1);
                    Array.set(array, 0, Array.newInstance(componentType.getComponentType(), 0));
                    return array;
                }
                return Array.newInstance(componentType, 0);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return CollectionUtil.createCollection(type, elementType, (int)16);
            }
            if (Map.class.isAssignableFrom(type)) {
                return MapUtil.createMap(type, elementType, (int)16);
            }
            Constructor<?> ctor = type.getDeclaredConstructor(new Class[0]);
            if (Modifier.isPrivate(ctor.getModifiers())) {
                if (this.allowCollectionAutoGrow) {
                    // empty if block
                }
                throw new IllegalAccessException("Auto-growing not allowed with private constructor: " + ctor);
            }
            return ReflectUtil.newInstance(ctor, (Object[])new Object[0]);
        }
        catch (Throwable ex) {
            throw new UtilException(ex, "Could not instantiate property type \"{}\" to auto-grow nested property path {}", new Object[]{type.getName(), name});
        }
    }

    protected abstract AbstractBeanPropertyAccessor newNestedPropertyAccessor(Object var1, String var2);

    private AbstractBeanPropertyAccessor getNestedPropertyAccessor(String nestedProperty) {
        PropertyToken tokens = this.getPropertyNameToken(nestedProperty);
        String canonicalName = tokens.canonicalName;
        this.ensurePropertyHoldingValueNotNull(tokens);
        Object value = this.getPropertyValue(tokens);
        if (this.allowCreateHoldValueIfNull && value == null) {
            PropertyHandle ph = this.getPropertyHandle(tokens.actualName);
            Class<?> clazz = tokens.keys != null ? ph.getNestedType(tokens.keys.length) : ph.getPropertyType();
            value = this.newValue(clazz, null, tokens.actualName);
            this.setPropertyValue(tokens, value);
        }
        if (value == null) {
            throw new BeanException("property \"{}\" is null", nestedProperty);
        }
        AbstractBeanPropertyAccessor propertyAccessor = this.newNestedPropertyAccessor(value, this.nestedPath + canonicalName + ".");
        return propertyAccessor;
    }

    protected static class PropertyToken {
        protected String actualName;
        protected String canonicalName;
        protected String[] keys;

        public PropertyToken(String propertyName) {
            this.actualName = propertyName;
            this.canonicalName = propertyName;
        }

        public PropertyToken clone() {
            PropertyToken token = new PropertyToken(this.actualName);
            token.canonicalName = this.canonicalName;
            token.keys = (String[])ObjectUtil.clone((Object)this.keys);
            return token;
        }

        public String getPath() {
            String canonicalName = this.actualName;
            if (ArrayUtil.isNotEmpty((Object[])this.keys)) {
                String str = "[".concat(StringUtil.join((Object[])this.keys, (String)"][")).concat("]");
                canonicalName = this.actualName.concat(str);
            }
            return canonicalName;
        }
    }

    protected static abstract class PropertyHandle {
        private String propertyName;
        private boolean read;
        private boolean write;

        public PropertyHandle(String propertyName, boolean read, boolean write) {
            this.propertyName = propertyName;
            this.read = read;
            this.write = write;
        }

        public boolean isRead() {
            return this.read;
        }

        public boolean isWrite() {
            return this.write;
        }

        public abstract Object getValue() throws Exception;

        public abstract void setValue(Object var1) throws Exception;

        public abstract Class<?> getPropertyType();

        public abstract Class<?> getCollectionType(int var1);

        public abstract Class<?> getMapKeyType(int var1);

        public abstract Class<?> getMapValueType(int var1);

        protected abstract Class<?> getNestedType(int var1, Map<Integer, Integer> var2);

        public Class<?> getNestedType(int nestingLevel) {
            return this.getNestedType(nestingLevel, null);
        }

        protected Class<?> resolveClass(Type type) {
            if (type == null) {
                return null;
            }
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof GenericArrayType) {
                return ((GenericArrayType)type).getGenericComponentType().getClass();
            }
            if (type instanceof ParameterizedType) {
                Type newType = ((ParameterizedType)type).getRawType();
                return this.resolveClass(newType);
            }
            return null;
        }
    }
}

