/*
 * Decompiled with CFR 0.152.
 */
package jexx.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jexx.bean.BeanException;
import jexx.bean.BeanInfoFactory;
import jexx.bean.SimpleBeanInfoFactory;

public class CachedIntrospectionResults {
    private static List<BeanInfoFactory> beanInfoFactories = new ArrayList<BeanInfoFactory>();
    static final ConcurrentMap<Class<?>, CachedIntrospectionResults> classCache;
    private final BeanInfo beanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorCache;

    public static CachedIntrospectionResults forClass(Class<?> beanClass) {
        CachedIntrospectionResults results = (CachedIntrospectionResults)classCache.get(beanClass);
        if (results != null) {
            return results;
        }
        results = new CachedIntrospectionResults(beanClass);
        classCache.put(beanClass, results);
        return results;
    }

    private static BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        for (BeanInfoFactory beanInfoFactory : beanInfoFactories) {
            BeanInfo beanInfo = beanInfoFactory.getBeanInfo(beanClass);
            if (beanInfo == null) continue;
            return beanInfo;
        }
        return Introspector.getBeanInfo(beanClass);
    }

    private CachedIntrospectionResults(Class<?> beanClass) {
        try {
            PropertyDescriptor[] pds;
            this.beanInfo = CachedIntrospectionResults.getBeanInfo(beanClass);
            this.propertyDescriptorCache = new LinkedHashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor pd : pds = this.beanInfo.getPropertyDescriptors()) {
                if (Class.class == beanClass && ("classLoader".equals(pd.getName()) || "protectionDomain".equals(pd.getName()))) continue;
                this.propertyDescriptorCache.put(pd.getName(), pd);
            }
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
    }

    BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    Class<?> getBeanClass() {
        return this.beanInfo.getBeanDescriptor().getBeanClass();
    }

    PropertyDescriptor[] getPropertyDescriptors() {
        PropertyDescriptor[] pds = new PropertyDescriptor[this.propertyDescriptorCache.size()];
        int i = 0;
        Iterator<PropertyDescriptor> iterator = this.propertyDescriptorCache.values().iterator();
        while (iterator.hasNext()) {
            PropertyDescriptor pd;
            pds[i] = pd = iterator.next();
            ++i;
        }
        return pds;
    }

    PropertyDescriptor getPropertyDescriptor(String name) {
        return this.propertyDescriptorCache.get(name);
    }

    boolean isBean() {
        for (Map.Entry<String, PropertyDescriptor> entry : this.propertyDescriptorCache.entrySet()) {
            if (entry.getValue().getWriteMethod() == null) continue;
            return true;
        }
        return false;
    }

    static {
        beanInfoFactories.add(new SimpleBeanInfoFactory());
        classCache = new ConcurrentHashMap(64);
    }
}

