/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.websocket.core.util;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketUtil {
    private static Logger logger = LoggerFactory.getLogger(SocketUtil.class);

    public static <T> Map<String, T> parseMapForFilter(Map<String, T> map, String filters) {
        if (map == null) {
            return Collections.emptyMap();
        }
        map = map.entrySet().stream().filter(e -> SocketUtil.checkKey((String)e.getKey(), filters)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return map;
    }

    private static boolean checkKey(String key, String filters) {
        return key.contains(filters);
    }

    public static boolean banConnection(String socketPath) {
        if (socketPath.contains("/socket/n/") || socketPath.contains("/socket/y/")) {
            return false;
        }
        logger.error(socketPath + "\u8def\u5f84\u4e0d\u5408\u6cd5\uff0c\u53ea\u5141\u8bb8\"/socket/y/\",\"/socket/n/\"");
        return true;
    }
}

