/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.websocket.core.service;

import cn.jdevelops.websocket.core.cache.LocalCache;
import cn.jdevelops.websocket.core.config.WebSocketConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.websocket.Session;
import org.springframework.stereotype.Service;

@Service
public class CacheService {
    public final WebSocketConfig webSocketConfig;

    public CacheService(WebSocketConfig webSocketConfig) {
        this.webSocketConfig = webSocketConfig;
    }

    public Session saveSession(String userName, Session session) {
        Session resultSession = null;
        ArrayList<Session> sessionsArray = new ArrayList<Session>();
        List<Session> sessions = this.loadSession(userName);
        if (this.webSocketConfig.isMultipart()) {
            if (sessions != null) {
                sessionsArray.addAll(sessions);
            }
            sessionsArray.add(session);
            this.saveSession(userName, sessionsArray);
        } else {
            if (sessions == null || sessions.isEmpty()) {
                sessionsArray.add(session);
                this.saveSession(userName, sessionsArray);
            }
            if (this.webSocketConfig.isOnClose()) {
                this.removeSession(userName);
                sessionsArray.add(session);
                this.saveSession(userName, sessionsArray);
                resultSession = sessions == null || sessions.isEmpty() ? null : sessions.get(0);
            } else if (Objects.nonNull(sessions) && !sessions.isEmpty()) {
                resultSession = session;
            }
        }
        return resultSession;
    }

    public void saveSession(String userName, List<Session> sessionsArray) {
        LocalCache.sessionPools.put(userName, sessionsArray);
    }

    public List<Session> loadSession(String userName) {
        return LocalCache.sessionPools.get(userName);
    }

    public Collection<List<Session>> loadSession() {
        return LocalCache.sessionPools.values();
    }

    public Map<String, List<Session>> loadSessionForPools() {
        return LocalCache.sessionPools;
    }

    public void removeSession(String userName) {
        LocalCache.sessionPools.remove(userName);
    }

    public void removeSession(String userName, Session session) {
        if (session == null) {
            this.removeSession(userName);
        } else {
            List<Session> sessions = this.loadSession(userName);
            sessions.remove(session);
            this.saveSession(userName, sessions);
        }
    }
}

