/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.websocket.core.scan;

import cn.jdevelops.websocket.core.config.AuthenticationConfigurator;
import cn.jdevelops.websocket.core.config.WebSocketConfig;
import cn.jdevelops.websocket.core.service.CacheService;
import cn.jdevelops.websocket.core.service.WebSocketServer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@ConditionalOnWebApplication
public class EnableAutoScanConfiguration {
    @ConditionalOnMissingBean(value={WebSocketConfig.class})
    @Bean
    public WebSocketConfig webSocketConfig() {
        return new WebSocketConfig();
    }

    @ConditionalOnMissingBean(value={CacheService.class})
    @Bean
    public CacheService cacheService(WebSocketConfig webSocketConfig) {
        return new CacheService(webSocketConfig);
    }

    @ConditionalOnMissingBean(value={WebSocketServer.class})
    @Bean
    public WebSocketServer webSocketServer(CacheService cacheService) {
        return new WebSocketServer(cacheService);
    }

    @ConditionalOnMissingBean(value={ServerEndpointExporter.class})
    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    @ConditionalOnMissingBean(value={AuthenticationConfigurator.class})
    @Bean
    public AuthenticationConfigurator serverConfigurator() {
        return new AuthenticationConfigurator();
    }
}

