/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.websocket.core.service;

import cn.jdevelops.websocket.core.config.ServerConfigurator;
import cn.jdevelops.websocket.core.constant.CommonConstant;
import cn.jdevelops.websocket.core.util.SocketUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/socket/{ver}/{name}", configurator=ServerConfigurator.class)
public class WebSocketServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebSocketServer.class);
    private static AtomicInteger online = new AtomicInteger();
    public static Map<String, List<Session>> sessionPoolsS = new HashMap<String, List<Session>>();

    public void sendMessage(Session session, String message) throws IOException {
        if (session != null) {
            session.getAsyncRemote().sendText(message);
        }
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="name") String userName, @PathParam(value="ver") String verify) {
        if (!CommonConstant.OK_PATH.contains(verify)) {
            log.error("\u7b2c\u4e8c\u8def\u5f84\u4e0d\u5408\u6cd5\uff0c\u7b2c\u4e8c\u8def\u5f84\u53ea\u80fd\u4e3a\uff1ay,n");
            return;
        }
        ArrayList<Session> sessionsArray = new ArrayList<Session>();
        List<Session> sessions = sessionPoolsS.get(userName);
        if (sessions != null) {
            sessionsArray.addAll(sessions);
        }
        sessionsArray.add(session);
        sessionPoolsS.put(userName, sessionsArray);
        WebSocketServer.addOnlineCount();
        log.info(userName + "\u52a0\u5165webSocket\uff01\u5f53\u524d\u4eba\u6570\u4e3a" + online);
        try {
            this.sendMessage(session, "\u6b22\u8fce" + userName + "\u52a0\u5165\u8fde\u63a5\uff01");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @OnClose
    public void onClose(@PathParam(value="name") String userName, Session session) {
        List<Session> sessions = sessionPoolsS.get(userName);
        if (session == null) {
            sessionPoolsS.remove(userName);
        } else {
            sessions.remove(session);
            sessionPoolsS.put(userName, sessions);
        }
        WebSocketServer.subOnlineCount();
        log.info(userName + "\u65ad\u5f00webSocket\u8fde\u63a5\uff01\u5f53\u524d\u4eba\u6570\u4e3a" + online);
    }

    @OnMessage
    public void onMessage(String message) {
        for (List<Session> session : sessionPoolsS.values()) {
            try {
                session.forEach(sessionf -> {
                    try {
                        this.sendMessage((Session)sessionf, message);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Throwable throwable) {
        throwable.printStackTrace();
    }

    public void sendInfo(String userName, String message) {
        List<Session> session = sessionPoolsS.get(userName);
        if (session != null) {
            try {
                session.forEach(sessionf -> {
                    try {
                        this.sendMessage((Session)sessionf, message);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void sendInfoByLikeKey(String userName, String message) {
        Map<String, List<Session>> stringListMap = SocketUtil.parseMapForFilter(sessionPoolsS, userName);
        ArrayList session = new ArrayList();
        stringListMap.forEach((key, value) -> session.addAll(value));
        try {
            session.forEach(sessionf -> {
                try {
                    this.sendMessage((Session)sessionf, message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addOnlineCount() {
        online.incrementAndGet();
    }

    public static void subOnlineCount() {
        online.decrementAndGet();
    }
}

