/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.websocket.core.config;

import cn.jdevelops.jwt.util.JwtUtil;
import cn.jdevelops.websocket.core.service.WebSocketServer;
import cn.jdevelops.websocket.core.util.SocketUtil;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.websocket.server.ServerEndpointConfig;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class ServerConfigurator
extends ServerEndpointConfig.Configurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerConfigurator.class);

    public boolean checkOrigin(String originHeaderValue) {
        boolean verity;
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        assert (servletRequestAttributes != null);
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String servletPath = request.getServletPath();
        if (SocketUtil.banConnection(servletPath)) {
            return false;
        }
        if (servletPath.contains("/socket/n/")) {
            return true;
        }
        String token = request.getParameter("token");
        if (Objects.isNull(token)) {
            token = request.getHeader("token");
        }
        if (!(verity = JwtUtil.verity((String)token))) {
            String topic = request.getServletPath();
            String substring = topic.substring(topic.lastIndexOf("/") + 1);
            WebSocketServer.sessionPoolsS.remove(substring);
        }
        return verity;
    }
}

