/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.jwtweb.interceptor;

import cn.jdevelops.enums.result.ResultCodeEnum;
import cn.jdevelops.jwtweb.annotation.ApiMapping;
import cn.jdevelops.jwtweb.holder.ApplicationContextHolder;
import cn.jdevelops.jwtweb.server.CheckTokenInterceptor;
import cn.jdevelops.jwtweb.server.impl.DefaultInterceptor;
import cn.jdevelops.result.result.ResultVO;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class WebApiInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebApiInterceptor.class);
    private CheckTokenInterceptor checkTokenInterceptor;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        Logger logger = LoggerFactory.getLogger((Class)handlerMethod.getBeanType());
        if (method.isAnnotationPresent(ApiMapping.class)) {
            ApiMapping annotation = method.getAnnotation(ApiMapping.class);
            if (annotation.checkToken()) {
                return this.check(request, response, handler, logger);
            }
            return true;
        }
        return this.check(request, response, handler, logger);
    }

    private boolean check(HttpServletRequest request, HttpServletResponse response, Object handler, Logger logger) throws IOException {
        String token = this.getToken(request);
        this.getCheckTokenInterceptor();
        boolean flag = this.checkTokenInterceptor.checkToken(token);
        logger.info("\u9700\u8981\u9a8c\u8bc1token,\u6821\u9a8c\u7ed3\u679c\uff1a{}", (Object)flag);
        if (!flag) {
            response.setHeader("content-type", "application/json;charset=UTF-8");
            response.getWriter().write(JSON.toJSONString((Object)ResultVO.fail((int)ResultCodeEnum.TokenError.getCode(), (String)"\u65e0\u6548\u7684token")));
            return false;
        }
        MDC.put((String)"token", (String)token);
        return true;
    }

    private String getToken(HttpServletRequest request) {
        String tokenName = "token";
        String token = request.getHeader("token");
        if (StringUtils.isNotBlank((CharSequence)token)) {
            return token;
        }
        token = request.getParameter("token");
        return token;
    }

    private void getCheckTokenInterceptor() {
        try {
            this.checkTokenInterceptor = (CheckTokenInterceptor)ApplicationContextHolder.get().getBean(CheckTokenInterceptor.class);
        }
        catch (Exception e) {
            this.checkTokenInterceptor = (CheckTokenInterceptor)ApplicationContextHolder.get().getBean(DefaultInterceptor.class);
        }
    }
}

