/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.jwtweb.config;

import cn.jdevelops.jwtweb.bean.InterceptorBean;
import cn.jdevelops.jwtweb.interceptor.WebApiInterceptor;
import java.util.ArrayList;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebApiConfig
implements WebMvcConfigurer {
    @Autowired(required=false)
    private InterceptorBean interceptorBean;

    @Bean
    public WebApiInterceptor webApiInterceptor() {
        return new WebApiInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        Set<String> addPathPatterns = this.interceptorBean.getAddPathPatterns();
        if (null == addPathPatterns || addPathPatterns.size() <= 0) {
            addPathPatterns.add("/**");
        }
        Set<String> excludePathPatterns = this.interceptorBean.getExcludePathPatterns();
        excludePathPatterns.add("/swagger-resources/**");
        excludePathPatterns.add("/webjars/**");
        excludePathPatterns.add("/v2/api-docs/**");
        excludePathPatterns.add("/v3/api-docs/**");
        excludePathPatterns.add("/swagger**/**");
        excludePathPatterns.add("/swagger-ui.html/**");
        excludePathPatterns.add("/doc.html/**");
        excludePathPatterns.add("/user/login/**");
        ArrayList<String> excludePathPatternsList = new ArrayList<String>(excludePathPatterns);
        ArrayList<String> addPathPatternsList = new ArrayList<String>(addPathPatterns);
        registry.addInterceptor((HandlerInterceptor)this.webApiInterceptor()).addPathPatterns(addPathPatternsList).excludePathPatterns(excludePathPatternsList);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
    }
}

