/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.spring.schema;

import cn.jdevelops.spring.properties.DataBaseProperties;
import cn.jdevelops.spring.schema.Resources;
import cn.jdevelops.spring.schema.ScriptRunner;
import com.google.common.base.Splitter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.core.io.ClassPathResource;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class LocalDataSourceLoader
implements InstantiationAwareBeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalDataSourceLoader.class);
    private static final String PRE_FIX = "file:";
    private static final String AUTO_INITSCRIPT_MYSQL = "CREATE DATABASE  IF NOT EXISTS  `%s`  DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci ;";
    private static final String AUTO_INITSCRIPT_PGSQL = " CREATE DATABASE  %s ;";
    @Resource
    private DataBaseProperties dataBaseProperties;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties && this.dataBaseProperties.getInitEnable().booleanValue()) {
            this.init((DataSourceProperties)bean);
        }
        return bean;
    }

    protected void init(DataSourceProperties properties) {
        Connection connection;
        String url = properties.getUrl();
        StringBuilder sb = new StringBuilder(url);
        String sub1 = url.substring(0, url.indexOf("?") < 0 ? url.length() : url.indexOf("?") - 1);
        int i = sub1.lastIndexOf("/");
        int j = sb.indexOf("?") < 0 ? sb.length() : sb.indexOf("?");
        String jdbcUrl = sb.replace(i, j, "").toString();
        AtomicInteger jdbcType = new AtomicInteger(0);
        String jdbcUrlPrefix = jdbcUrl.substring(0, jdbcUrl.lastIndexOf(":") - 1);
        if (properties.getDriverClassName().contains("postgresql") || jdbcUrlPrefix.contains("postgresql")) {
            connection = DriverManager.getConnection(jdbcUrl + "/", properties.getUsername(), properties.getPassword());
            jdbcType.set(1);
        } else if (properties.getDriverClassName().contains("mysql") || jdbcUrlPrefix.contains("mysql")) {
            connection = DriverManager.getConnection(jdbcUrl, properties.getUsername(), properties.getPassword());
            jdbcType.set(2);
        } else {
            log.info("\u6682\u4e0d\u652f\u6301\u6b64\u7c7b\u578b\u6570\u636e\u5e93\u81ea\u52a8\u521b\u5efa\u6570\u636e\u5e93:" + properties.getDriverClassName());
            return;
        }
        this.execute(connection, properties.getUrl().substring(i + 1, j), jdbcType);
    }

    private void execute(Connection conn, String schemaName, AtomicInteger jdbcType) throws Exception {
        ScriptRunner runner = new ScriptRunner(conn);
        runner.setLogWriter(null);
        Resources.setCharset(StandardCharsets.UTF_8);
        String initScript = this.dataBaseProperties.getInitScript();
        if ("auto".equalsIgnoreCase(initScript) || StringUtils.isBlank((CharSequence)initScript)) {
            switch (jdbcType.get()) {
                case 1: {
                    String checkSchema = "select count(*) as isok from pg_catalog.pg_database where datname = '" + schemaName + "' ;";
                    Statement statement = conn.createStatement();
                    ResultSet resultSet = statement.executeQuery(checkSchema);
                    int isok = 0;
                    while (resultSet.next()) {
                        isok = resultSet.getInt(1);
                    }
                    statement.close();
                    if (isok == 0) {
                        initScript = String.format(AUTO_INITSCRIPT_PGSQL, schemaName);
                        runner.setAutoCommit(true);
                        break;
                    }
                    log.info("\u5f53\u524d\u5e93(" + schemaName + ")\u5df2\u5b58\u5728\uff0c\u4e0d\u7528\u5728\u81ea\u52a8\u521b\u5efa");
                    runner.closeConnection();
                    conn.close();
                    return;
                }
                case 2: {
                    initScript = String.format(AUTO_INITSCRIPT_MYSQL, schemaName);
                    break;
                }
                default: {
                    runner.closeConnection();
                    conn.close();
                    return;
                }
            }
            Reader fileReader = LocalDataSourceLoader.getResourceAsReaderStr(initScript);
            log.info("execute auto schema sql: {}", (Object)initScript);
            runner.runScript(fileReader);
        } else {
            List initScripts = Splitter.on((String)";").splitToList((CharSequence)initScript);
            for (String sqlScript : initScripts) {
                if (sqlScript.startsWith(PRE_FIX)) {
                    String sqlFile = sqlScript.substring(PRE_FIX.length());
                    Reader fileReader = LocalDataSourceLoader.getResourceAsReader(sqlFile);
                    log.info("execute auto schema sql: {}", (Object)sqlFile);
                    runner.runScript(fileReader);
                    continue;
                }
                Reader fileReader = LocalDataSourceLoader.getResourceAsReader(sqlScript);
                log.info("execute auto schema sql: {}", (Object)sqlScript);
                runner.runScript(fileReader);
            }
        }
        runner.closeConnection();
        conn.close();
    }

    private static Reader getResourceAsReader(String resource) throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(resource);
        return new InputStreamReader(classPathResource.getInputStream(), StandardCharsets.UTF_8);
    }

    private static Reader getResourceAsReaderStr(String resource) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes(StandardCharsets.UTF_8));
        return new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
    }
}

