/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.spring.core.jar;

import java.security.CodeSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionUtils.class);
    private static final String VERSION = VersionUtils.getVersion(VersionUtils.class, "1.0.0");
    private static final String JAR = ".jar";

    private VersionUtils() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        String version = cls.getPackage().getImplementationVersion();
        if (StringUtils.isBlank((CharSequence)version)) {
            version = cls.getPackage().getSpecificationVersion();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{version})) {
            return version;
        }
        CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            LOGGER.info("No codeSource for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
            return defaultVersion;
        }
        String file = codeSource.getLocation().getFile();
        if (file != null && file.endsWith(JAR)) {
            int i = (file = file.substring(0, file.length() - 4)).lastIndexOf(47);
            if (i >= 0) {
                file = file.substring(i + 1);
            }
            if ((i = file.indexOf("-")) >= 0) {
                file = file.substring(i + 1);
            }
            while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
                file = file.substring(i + 1);
            }
            version = file;
        }
        return StringUtils.isBlank((CharSequence)version) ? defaultVersion : version;
    }
}

