/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.spring.core.jar;

import cn.hutool.core.io.file.FileWriter;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.crypto.SecureUtil;
import cn.jdevelops.http.core.MacUtil;
import cn.jdevelops.spring.core.system.OSinfo;
import cn.jdevelops.spring.entity.JarAddFile;
import cn.jdevelops.spring.enums.EPlatform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.springframework.util.ClassUtils;

public class JarUtil {
    static String property = System.getProperty("user.home");

    public static void bindingMachine(List<EPlatform> os) throws Exception {
        EPlatform oSname = OSinfo.getOSname();
        if (os.contains((Object)oSname)) {
            throw new RuntimeException("\u5f53\u524d\u5e73\u53f0\u4e0d\u5141\u8bb8\u4f7f\u7528\u8be5Jar!");
        }
        JarUtil.bindingMachine();
    }

    public static String bindingMachine() throws Exception {
        block4: {
            String jarPath = JarUtil.getJarPath();
            String macAddress = MacUtil.getMacAddress();
            try {
                String str = ResourceUtil.readUtf8Str((String)"test.txt");
                if (null != str && str.length() > 0 && SecureUtil.md5((String)macAddress).equals(str)) {
                    return "jar\u6388\u6743\u5931\u8d25!";
                }
            }
            catch (Exception e) {
                if (null == macAddress || macAddress.trim().length() <= 0) break block4;
                ArrayList<JarAddFile> jarAddFiles = new ArrayList<JarAddFile>();
                FileWriter writer = new FileWriter(property + "/test.txt");
                File file = writer.write(SecureUtil.md5((String)macAddress));
                String isJarUp = JarUtil.class.getResource("AstrictJarApplication.class").toString();
                String substring = isJarUp.substring(0, isJarUp.indexOf(":"));
                if ("jar".equalsIgnoreCase(substring)) {
                    JarAddFile jarAddFile = new JarAddFile();
                    jarAddFile.setFilesToAdd(file);
                    jarAddFile.setFilesToAddRelativePath(MacUtil.win2Linux((String)"BOOT-INF/classes/"));
                    jarAddFiles.add(jarAddFile);
                    JarUtil.updateJarFile(new File(jarPath), true, jarAddFiles);
                }
                return "jar\u6388\u6743\u6210\u529f!";
            }
        }
        throw new RuntimeException("\u5f53\u524djar\u672a\u7ecf\u6388\u6743!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateJarFile(File srcJarFile, boolean update, List<JarAddFile> filesToAdd) throws IOException {
        File tmpJarFile = File.createTempFile("tempJar", ".tmp");
        JarFile jarFile = new JarFile(srcJarFile);
        boolean jarUpdated = false;
        ArrayList<String> fileNames = new ArrayList<String>();
        try (JarOutputStream tempJarOutputStream = new JarOutputStream(new FileOutputStream(tmpJarFile));){
            int bytesRead;
            byte[] buffer;
            for (int i = 0; i < filesToAdd.size(); ++i) {
                File file = filesToAdd.get(i).getFilesToAdd();
                String fileRelativePath = filesToAdd.get(i).getFilesToAddRelativePath();
                try (FileInputStream fis = new FileInputStream(file);){
                    buffer = new byte[1024];
                    bytesRead = 0;
                    JarEntry entry = new JarEntry(fileRelativePath + file.getName());
                    fileNames.add(entry.getName());
                    tempJarOutputStream.putNextEntry(entry);
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        tempJarOutputStream.write(buffer, 0, bytesRead);
                    }
                    continue;
                }
            }
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                Object[] fileNameArray = fileNames.toArray(new String[0]);
                Arrays.sort(fileNameArray);
                if (Arrays.binarySearch(fileNameArray, entry.getName()) < 0) {
                    InputStream entryInputStream = jarFile.getInputStream(entry);
                    tempJarOutputStream.putNextEntry(entry);
                    buffer = new byte[1024];
                    while ((bytesRead = entryInputStream.read(buffer)) != -1) {
                        tempJarOutputStream.write(buffer, 0, bytesRead);
                    }
                    continue;
                }
                if (update) continue;
                throw new IOException("Jar Update Aborted: Entry " + entry.getName() + " could not be added to the jar file because it already exists and the update parameter was false");
            }
            jarUpdated = true;
        }
        finally {
            jarFile.close();
            if (!jarUpdated) {
                tmpJarFile.delete();
            }
        }
        if (jarUpdated) {
            srcJarFile.delete();
            tmpJarFile.renameTo(srcJarFile);
        }
    }

    public static String getJarPath() {
        String substring;
        String path = ClassUtils.getDefaultClassLoader().getResource("").getPath();
        String os = System.getProperty("os.name");
        if (path.contains("!")) {
            path = path.substring(0, path.indexOf("!"));
        }
        if ("jar".equalsIgnoreCase(substring = path.substring(0, path.indexOf(":")))) {
            path = path.substring(path.indexOf(":") + 1);
        }
        if ("file".equalsIgnoreCase(substring)) {
            path = path.substring(path.indexOf(":") + 1);
        }
        if (os.toLowerCase().startsWith("win")) {
            path = path.substring(1).replace("/", "\\");
        }
        return path;
    }
}

