/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.spring.core.jar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class JarExecutor {
    private BufferedReader error;
    private BufferedReader op;
    private int exitVal;

    public void executeJar(String jarFilePath, List args) {
        ArrayList<String> actualArgs = new ArrayList<String>();
        actualArgs.add(0, "java");
        actualArgs.add(1, "-jar");
        actualArgs.add(2, jarFilePath);
        if (args != null && args.size() > 0) {
            actualArgs.addAll(args);
        }
        try {
            Runtime re = Runtime.getRuntime();
            Process command = re.exec(actualArgs.toArray(new String[0]));
            this.error = new BufferedReader(new InputStreamReader(command.getErrorStream()));
            this.op = new BufferedReader(new InputStreamReader(command.getInputStream()));
            command.waitFor();
            this.exitVal = command.exitValue();
            if (this.exitVal != 0) {
                throw new IOException("Failed to execure jar, " + this.getExecutionLog());
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String getExecutionLog() {
        String line;
        String error = "";
        try {
            while ((line = this.error.readLine()) != null) {
                error = error + "\n" + line;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String output = "";
        try {
            while ((line = this.op.readLine()) != null) {
                output = output + "\n" + line;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.error.close();
            this.op.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "exitVal: " + this.exitVal + ", error: " + error + ", output: " + output;
    }
}

