/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.aops;

import cn.jdevelops.aops.StringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class AopReasolver {
    private static AopReasolver resolver;

    public static AopReasolver newInstance() {
        if (resolver == null) {
            resolver = new AopReasolver();
            return resolver;
        }
        return resolver;
    }

    public Object resolver(JoinPoint joinPoint, String str) {
        if (StringUtil.isBlank(str)) {
            return null;
        }
        Object value = null;
        String substring1 = null;
        if (str.contains("#")) {
            substring1 = str.substring(0, str.indexOf("#"));
            String substring2 = str.substring(str.indexOf("#"));
            if (substring2.matches("#\\{\\D*}")) {
                String newStr = substring2.replaceAll("#\\{", "").replaceAll("}", "");
                if (newStr.contains(".")) {
                    try {
                        value = this.complexResolver(joinPoint, newStr);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    value = this.simpleResolver(joinPoint, newStr);
                }
            } else {
                value = str;
            }
        } else {
            value = str;
        }
        return StringUtil.isBlank(substring1) ? value : substring1 + value;
    }

    private Object complexResolver(JoinPoint joinPoint, String str) throws Exception {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] names = methodSignature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        String[] stars = str.split("\\.");
        for (int i = 0; i < names.length; ++i) {
            if (!stars[0].equals(names[i])) continue;
            Object obj = args[i];
            if (obj instanceof Map) {
                return this.getValueByMap(obj, stars);
            }
            Method dmethod = obj.getClass().getDeclaredMethod(this.getMethodName(stars[1]), new Class[0]);
            Object value = dmethod.invoke(args[i], new Object[0]);
            return this.getValueByBean(value, 1, stars);
        }
        return null;
    }

    private Object getValueByMap(Object obj, String[] strs) {
        try {
            Map map = (Map)obj;
            if (map.containsKey(strs[1])) {
                return map.get(strs[1]);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object getValueByBean(Object obj, int index, String[] strs) {
        try {
            if (obj != null && index < strs.length - 1) {
                Method method = obj.getClass().getDeclaredMethod(this.getMethodName(strs[index + 1]), new Class[]{null});
                obj = method.invoke(obj, new Object[0]);
                this.getValueByBean(obj, index + 1, strs);
            }
            return obj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getMethodName(String name) {
        return "get" + name.replaceFirst(name.substring(0, 1), name.substring(0, 1).toUpperCase());
    }

    private Object simpleResolver(JoinPoint joinPoint, String str) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] names = methodSignature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < names.length; ++i) {
            if (!str.equals(names[i])) continue;
            return args[i];
        }
        return null;
    }
}

