/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.message.config.wx;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import cn.jdevelops.message.properties.wx.WxMaProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={WxMaProperties.class})
@Configuration
public class WxMaConfigration {
    private final WxMaProperties wxMaProperties;

    public WxMaConfigration(WxMaProperties wxMaProperties) {
        this.wxMaProperties = wxMaProperties;
    }

    public WxMaConfig wxMaConfig() {
        WxMaDefaultConfigImpl wxMpDefaultConfig = new WxMaDefaultConfigImpl();
        wxMpDefaultConfig.setAppid(this.wxMaProperties.getAppid());
        wxMpDefaultConfig.setSecret(this.wxMaProperties.getSecret());
        String msgDataFormat = this.wxMaProperties.getMsgDataFormat().toUpperCase();
        wxMpDefaultConfig.setMsgDataFormat(StringUtils.isBlank((CharSequence)msgDataFormat) ? "JSON" : msgDataFormat);
        return wxMpDefaultConfig;
    }

    @Bean
    public WxMaService wxMaService() {
        WxMaServiceImpl wxMpService = new WxMaServiceImpl();
        wxMpService.setWxMaConfig(this.wxMaConfig());
        return wxMpService;
    }
}

