/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.map.core.map;

import cn.jdevelops.enums.number.NumEnum;
import cn.jdevelops.enums.string.StringEnum;
import cn.jdevelops.json.GsonUtils;
import cn.jdevelops.map.core.map.MapSortUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class MapUtil {
    private static final Pattern PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    private static final String CONTAINS_KEY_EMPTY = "empty";

    public static Map<String, Object> object2Map(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (obj == null) {
            return map;
        }
        Class<?> clazz = obj.getClass();
        Field[] fields = clazz.getDeclaredFields();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                map.put(field.getName(), field.get(obj));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> beanClass) throws Exception {
        if (map == null) {
            return null;
        }
        T obj = beanClass.newInstance();
        BeanUtils.populate(obj, map);
        return obj;
    }

    public static Object transMap2Bean(Map<String, Object> map, Object obj) {
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (!map.containsKey(key)) continue;
                Object value = map.get(key);
                Method setter = property.getWriteMethod();
                setter.invoke(obj, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return obj;
    }

    public static Map<String, Object> beanToMap(Object obj) {
        Map<String, Object> params = new HashMap<String, Object>(0);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
            }
            if (obj != null && params.containsKey(StringEnum.EMPTY_STRING.getStr())) {
                params = (Map)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static <K, V> String toMap(Supplier<MultiValueMap<K, V>> supplier) {
        return GsonUtils.getInstance().toJson((Object)supplier.get().toSingleValueMap());
    }

    public static Map<String, String> initQueryParams(String query) {
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        if (!StringUtils.isEmpty((Object)query)) {
            Matcher matcher = PATTERN.matcher(query);
            while (matcher.find()) {
                String name = MapUtil.decodeQueryParam(matcher.group(1));
                String eq = matcher.group(2);
                String value = matcher.group(3);
                value = !StringUtils.isEmpty((Object)value) ? MapUtil.decodeQueryParam(value) : (StringUtils.hasLength((String)eq) ? "" : null);
                queryParams.put(name, value);
            }
        }
        return queryParams;
    }

    public static MultiValueMap<String, Object> beanToLinkedMultiValueMap(Object obj) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.add((Object)name, propertyUtilsBean.getNestedProperty(obj, name));
            }
            if (obj != null && params.containsKey((Object)CONTAINS_KEY_EMPTY)) {
                params = (MultiValueMap)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static LinkedHashMap<String, Object> beanToLinkedHashMap(Object obj) {
        LinkedHashMap params = new LinkedHashMap();
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
            }
            if (obj != null && params.containsKey(CONTAINS_KEY_EMPTY)) {
                params = (LinkedHashMap)obj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static Map<String, Object> getRepetitionListElementNum(List<String> list, Integer type) {
        Map<String, Object> beanToMap = new HashMap<String, Object>(list.size());
        try {
            HashMap<String, Integer> chongfu = new HashMap<String, Integer>(list.size());
            for (String string : list) {
                if (null == string) continue;
                string = string.toLowerCase();
                int i = 1;
                for (String string2 : list) {
                    if (!string.equals(string2 = string2.toLowerCase())) continue;
                    chongfu.put(string, i);
                    ++i;
                }
            }
            Map dataMap = new Map();
            if (1 == type) {
                dataMap = MapSortUtil.sortByValueAscending(chongfu);
            } else if (NumEnum.TWO.getNum().equals(type)) {
                dataMap = MapSortUtil.sortByValueDescending(chongfu);
            }
            beanToMap = MapUtil.beanToMap(dataMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return beanToMap;
    }

    public static Map<String, Object> getfirstMapElement(Map<String, Object> map) {
        Map.Entry<String, Object> next = map.entrySet().iterator().next();
        Map<String, Object> beanToMap = null;
        try {
            beanToMap = MapUtil.beanToMap(next);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return beanToMap;
    }

    public static Map<String, Object> getlastMapElement(Map<String, Object> map) {
        Map<String, Object> beanToMap = null;
        try {
            Field tail = map.getClass().getDeclaredField("tail");
            tail.setAccessible(true);
            Object object = tail.get(map);
            beanToMap = MapUtil.beanToMap(object);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return beanToMap;
    }

    public static Map<String, Object> transBean2Map(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                Method getter;
                Object value;
                String key = property.getName();
                if ("class".equals(key) || null == (value = (getter = property.getReadMethod()).invoke(obj, new Object[0])) || "".equals(value)) continue;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static <T> Map<String, T> parseMapForFilter(Map<String, T> map, String filters) {
        if (map == null) {
            return Collections.emptyMap();
        }
        map = map.entrySet().stream().filter(e -> MapUtil.checkKey((String)e.getKey(), filters)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return map;
    }

    private static boolean checkKey(String key, String filters) {
        return key.contains(filters);
    }

    public static String decodeQueryParam(String value) {
        return URLDecoder.decode(value, "UTF-8");
    }
}

