/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.map.core.bean;

import cn.jdevelops.string.StringFormat;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;

public class ColumnUtil {
    static Boolean defaultToLine = false;

    public static <T> String getFieldName(SFunction<T, ?> fn) {
        return ColumnUtil.getFieldName(fn, defaultToLine);
    }

    public static <T> String getFieldName(SFunction<T, ?> fn, Boolean toLine) {
        Field field;
        SerializedLambda serializedLambda = ColumnUtil.getSerializedLambda(fn);
        String fieldName = serializedLambda.getImplMethodName().substring("get".length());
        fieldName = fieldName.replaceFirst(fieldName.charAt(0) + "", (fieldName.charAt(0) + "").toLowerCase());
        Class<?> aClass = null;
        try {
            aClass = Class.forName(serializedLambda.getImplClass().replace("/", "."));
            field = aClass.getDeclaredField(fieldName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException ne) {
            field = ColumnUtil.superclass(aClass, fieldName);
        }
        TableField tableField = field.getAnnotation(TableField.class);
        if (tableField != null && tableField.value().length() > 0) {
            return tableField.value();
        }
        if (Boolean.TRUE.equals(toLine)) {
            return StringFormat.toLine((String)fieldName);
        }
        return fieldName;
    }

    private static <T> SerializedLambda getSerializedLambda(SFunction<T, ?> fn) {
        SerializedLambda serializedLambda;
        Method writeReplaceMethod;
        try {
            writeReplaceMethod = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        boolean isAccessible = writeReplaceMethod.isAccessible();
        writeReplaceMethod.setAccessible(true);
        try {
            serializedLambda = (SerializedLambda)writeReplaceMethod.invoke(fn, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        writeReplaceMethod.setAccessible(isAccessible);
        return serializedLambda;
    }

    private static Field superclass(Class<?> aClass, String fieldName) {
        try {
            return aClass.getSuperclass().getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return ColumnUtil.superclass(aClass, fieldName);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TableField {
        public String value() default "";
    }

    @FunctionalInterface
    public static interface SFunction<T, R>
    extends Function<T, R>,
    Serializable {
    }
}

