/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.map.core.bean;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class BeanCopier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BeanCopier.class);

    public static void copy(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
        Field[] sourceDeclaredFields = BeanCopier.getAllField(source.getClass());
        Field[] targetDeclaredFields = BeanCopier.getAllField(target.getClass());
        for (Field sourceField : sourceDeclaredFields) {
            Field targetField;
            String simpleName = sourceField.getType().getSimpleName();
            if (!simpleName.equals(Date.class.getSimpleName()) && !simpleName.equals(LocalDateTime.class.getSimpleName()) || (targetField = BeanCopier.getSameNameField(targetDeclaredFields, sourceField)) == null || !targetField.getType().isAssignableFrom(String.class)) continue;
            try {
                sourceField.setAccessible(true);
                targetField.setAccessible(true);
                if (sourceField.get(source) == null) {
                    targetField.set(target, null);
                    continue;
                }
                if (simpleName.equals(Date.class.getSimpleName())) {
                    Date date = (Date)sourceField.get(source);
                    long second = date.toInstant().atOffset(ZoneOffset.ofHours(8)).toEpochSecond();
                    LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(second, 0, ZoneOffset.ofHours(8));
                    targetField.set(target, localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    continue;
                }
                if (simpleName.equals(LocalDateTime.class.getSimpleName())) {
                    LocalDateTime localDateTime = (LocalDateTime)sourceField.get(source);
                    targetField.set(target, localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    continue;
                }
                if (!simpleName.equals(Timestamp.class.getSimpleName())) continue;
                Timestamp time = (Timestamp)sourceField.get(source);
                LocalDateTime localDateTime = time.toLocalDateTime();
                targetField.set(target, localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            catch (IllegalAccessException var11) {
                log.error(var11.getMessage(), (Throwable)var11);
            }
        }
    }

    public static <T> T copy(Object source, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            BeanCopier.copy(source, t);
            return t;
        }
        catch (IllegalAccessException | InstantiationException var3) {
            log.error(var3.getMessage(), (Throwable)var3);
            return null;
        }
    }

    public static <T> List<T> listCopy(List<?> sources, Class<T> clazz) {
        return sources == null ? new ArrayList() : sources.stream().map(source -> BeanCopier.copy(source, clazz)).collect(Collectors.toList());
    }

    private static Field[] getAllField(Class clazz) {
        Field[] array = null;
        while (clazz != Object.class) {
            Object[] field = clazz.getDeclaredFields();
            array = (Field[])ArrayUtils.addAll(array, (Object[])field);
            clazz = clazz.getSuperclass();
        }
        return array;
    }

    private static Field getSameNameField(Field[] fields, Field targetField) {
        for (Field field : fields) {
            if (!field.getName().equals(targetField.getName())) continue;
            return field;
        }
        return null;
    }
}

