/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.map.core.bean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;

public class BeanUtil {
    public static <M> void merge(M target, M destination) throws Exception {
        BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass());
        for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
            Object defaultValue;
            if (descriptor.getWriteMethod() == null || (defaultValue = descriptor.getReadMethod().invoke(destination, new Object[0])) == null || "".equals(defaultValue)) continue;
            descriptor.getWriteMethod().invoke(target, defaultValue);
        }
    }

    public static <T> void mergeObject(T origin, T destination) {
        if (origin == null || destination == null) {
            return;
        }
        if (!origin.getClass().equals(destination.getClass())) {
            return;
        }
        Field[] fields = destination.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                fields[i].setAccessible(true);
                Object valueD = fields[i].get(origin);
                Object valueO = fields[i].get(destination);
                if (null == valueO) {
                    fields[i].set(destination, valueD);
                }
                fields[i].setAccessible(false);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

