/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.map.core.bean;

import cn.jdevelops.map.core.bean.BeanCopier;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class BeanCopyUtil {
    public static <T> void beanCopy(T source, T target) {
        BeanUtils.copyProperties(source, target, (String[])BeanCopyUtil.getNullPropertyNames(source));
    }

    public static <T> void beanCopyWithIngore(T source, T target, String ... ignoreProperties) {
        String[] pns = BeanCopyUtil.getNullAndIgnorePropertyNames(source, ignoreProperties);
        BeanUtils.copyProperties(source, target, (String[])pns);
    }

    public static String[] getNullAndIgnorePropertyNames(Object source, String ... ignoreProperties) {
        Set<String> emptyNames = BeanCopyUtil.getNullPropertyNameSet(source);
        emptyNames.addAll(Arrays.asList(ignoreProperties));
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static String[] getNullPropertyNames(Object source) {
        Set<String> emptyNames = BeanCopyUtil.getNullPropertyNameSet(source);
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static Set<String> getNullPropertyNameSet(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        return emptyNames;
    }

    public static <T> T to(Class<T> tClass, Object t) {
        try {
            T tag = tClass.newInstance();
            BeanCopier.copy(t, tag);
            return tag;
        }
        catch (Exception var3) {
            throw new RuntimeException(var3);
        }
    }
}

