/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.list.core;

import java.util.ArrayList;
import java.util.List;

public class ListPage<T> {
    private List<T> list;
    private Integer total;
    private Integer currentPage;
    private Integer totalPages;
    private Integer pageSize;
    private Integer previousPage;
    private Integer nextPage;

    public ListPage(List<T> list, Integer currentPage, Integer pageSize) {
        this.list = list;
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.setTotal();
        this.setTotalPages();
        this.setNextPage();
        this.setPreviousPage();
        this.getResult();
    }

    public ListPage() {
    }

    public static <T> ListPage<T> page(List<T> list, Integer currentPage, Integer pageSize) {
        return new ListPage<T>(list, currentPage, pageSize);
    }

    private void getResult() {
        if (this.pageSize < this.total && this.pageSize > 0) {
            if (this.currentPage <= this.totalPages - 1 && this.currentPage >= 0) {
                int start = (this.currentPage - 1) * this.pageSize;
                int end = this.currentPage * this.pageSize - 1;
                this.setData(start, end);
            } else if (this.currentPage.equals(this.totalPages)) {
                int start = (this.currentPage - 1) * this.pageSize;
                int end = this.total - 1;
                this.setData(start, end);
            } else {
                this.setData(-1, -1);
            }
        }
    }

    private void setData(int start, int end) {
        if (start == -1 && end == -1) {
            this.setList(new ArrayList());
        } else if (start >= 0 && end < this.total) {
            ArrayList<T> list1 = new ArrayList<T>();
            for (int i = start; i <= end; ++i) {
                list1.add(this.list.get(i));
            }
            this.list.clear();
            this.setList(list1);
        }
    }

    public Integer getPreviousPage() {
        return this.previousPage;
    }

    public void setPreviousPage() {
        this.previousPage = this.currentPage > 0 ? this.currentPage - 1 : this.currentPage;
    }

    public Integer getNextPage() {
        return this.nextPage;
    }

    public void setNextPage() {
        this.nextPage = this.currentPage < this.totalPages ? this.currentPage + 1 : this.currentPage;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public Integer getTotal() {
        return this.total;
    }

    public void setTotal() {
        this.total = this.list.size();
    }

    public Integer getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages() {
        this.totalPages = (int)Math.ceil(1.0 * (double)this.total.intValue() / (double)this.pageSize.intValue());
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public String toString() {
        return "Page{list=" + this.list + ", total=" + this.total + ", currentPage=" + this.currentPage + ", totalPages=" + this.totalPages + ", pageSize=" + this.pageSize + ", previousPage=" + this.previousPage + ", nextPage=" + this.nextPage + '}';
    }
}

