/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.list.core;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class BeanCopier {
    protected static void copy(Object source, Object target) {
        BeanUtils.copyProperties((Object)source, (Object)target);
        Field[] sourceDeclaredFields = BeanCopier.getAllField(source.getClass());
        Field[] targetDeclaredFields = BeanCopier.getAllField(target.getClass());
        for (Field sourceField : sourceDeclaredFields) {
            Field targetField;
            String simpleName = sourceField.getType().getSimpleName();
            if (!simpleName.equals(Date.class.getSimpleName()) && !simpleName.equals(LocalDateTime.class.getSimpleName()) || (targetField = BeanCopier.getSameNameField(targetDeclaredFields, sourceField)) == null || !targetField.getType().getSimpleName().equals(String.class.getSimpleName())) continue;
            try {
                sourceField.setAccessible(true);
                targetField.setAccessible(true);
                if (sourceField.get(source) == null) {
                    targetField.set(target, null);
                    continue;
                }
                if (simpleName.equals(Date.class.getSimpleName())) {
                    Date date = (Date)sourceField.get(source);
                    long second = date.toInstant().atOffset(ZoneOffset.ofHours(8)).toEpochSecond();
                    LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(second, 0, ZoneOffset.ofHours(8));
                    targetField.set(target, localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    continue;
                }
                if (simpleName.equals(LocalDateTime.class.getSimpleName())) {
                    LocalDateTime localDateTime = (LocalDateTime)sourceField.get(source);
                    targetField.set(target, localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                    continue;
                }
                if (!simpleName.equals(Timestamp.class.getSimpleName())) continue;
                Timestamp time = (Timestamp)sourceField.get(source);
                LocalDateTime localDateTime = time.toLocalDateTime();
                targetField.set(target, localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            catch (IllegalAccessException var11) {
                var11.printStackTrace();
            }
        }
    }

    public static <T> T copy(Object source, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            BeanCopier.copy(source, t);
            return t;
        }
        catch (IllegalAccessException | InstantiationException var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> listCopy(List<?> sources, Class<T> clazz) {
        return sources == null ? new ArrayList() : sources.stream().map(source -> BeanCopier.copy(source, clazz)).collect(Collectors.toList());
    }

    private static Field[] getAllField(Class clazz) {
        Field[] array = null;
        while (clazz != Object.class) {
            Field[] field = clazz.getDeclaredFields();
            array = BeanCopier.addAll(array, field);
            clazz = clazz.getSuperclass();
        }
        return array;
    }

    private static Field getSameNameField(Field[] fields, Field targetField) {
        for (Field field : fields) {
            if (!field.getName().equals(targetField.getName())) continue;
            return field;
        }
        return null;
    }

    protected static <T> T[] addAll(T[] array1, T ... array2) {
        if (array1 == null) {
            return BeanCopier.clone(array2);
        }
        if (array2 == null) {
            return BeanCopier.clone(array1);
        }
        Class<?> type1 = array1.getClass().getComponentType();
        Object[] joinedArray = (Object[])Array.newInstance(type1, array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName(), ase);
            }
            throw ase;
        }
        return joinedArray;
    }

    protected static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }
}

