/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.list.core;

import cn.jdevelops.list.core.BeanCopier;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class ListTo {
    public static <T, K> List<T> to(Class<T> tClass, List<K> list) {
        return list.stream().map(entity -> ListTo.beanTo(tClass, entity)).collect(Collectors.toList());
    }

    private static <T> T beanTo(Class<T> tClass, Object t) {
        try {
            T tag = tClass.newInstance();
            BeanCopier.copy(t, tag);
            return tag;
        }
        catch (Exception var3) {
            throw new RuntimeException(var3);
        }
    }

    private static <T> void beanCopy(T source, T target) {
        BeanUtils.copyProperties(source, target, (String[])ListTo.getNullPropertyNames(source));
    }

    private static String[] getNullPropertyNames(Object source) {
        Set<String> emptyNames = ListTo.getNullPropertyNameSet(source);
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    private static Set<String> getNullPropertyNameSet(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        return emptyNames;
    }
}

