/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.jwt.util;

import cn.jdevelops.enums.result.ResultCodeEnum;
import cn.jdevelops.jwt.bean.JwtBean;
import cn.jdevelops.jwt.util.ContextUtil;
import com.alibaba.fastjson.JSONObject;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class JwtUtil {
    private static final Logger logger = LoggerFactory.getLogger(JwtUtil.class);
    private static final String JWT_BEAN_STR = "jwtBean";

    public static String sign(String loginName) {
        JwtBean jwtBean = (JwtBean)ContextUtil.getBean(JWT_BEAN_STR);
        Date date = new Date(System.currentTimeMillis() + jwtBean.getExpireTime());
        Algorithm algorithm = Algorithm.HMAC256((String)jwtBean.getTokenSecret());
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("typ", "JWT");
        header.put("alg", "HS256");
        return JWT.create().withHeader(header).withClaim("loginName", loginName).withSubject(loginName).withExpiresAt(date).sign(algorithm);
    }

    public static String sign(String loginName, JSONObject remark) {
        JwtBean jwtBean = (JwtBean)ContextUtil.getBean(JWT_BEAN_STR);
        Date date = new Date(System.currentTimeMillis() + jwtBean.getExpireTime());
        Algorithm algorithm = Algorithm.HMAC256((String)jwtBean.getTokenSecret());
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("typ", "JWT");
        header.put("alg", "HS256");
        return JWT.create().withHeader(header).withClaim("loginName", loginName).withSubject(loginName).withClaim("remark", remark == null ? "" : remark.toJSONString()).withExpiresAt(date).sign(algorithm);
    }

    public static String sign(String loginName, JSONObject remark, long expireTime) {
        JwtBean jwtBean = (JwtBean)ContextUtil.getBean(JWT_BEAN_STR);
        Date date = new Date(expireTime);
        Algorithm algorithm = Algorithm.HMAC256((String)jwtBean.getTokenSecret());
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("typ", "JWT");
        header.put("alg", "HS256");
        return JWT.create().withHeader(header).withClaim("loginName", loginName).withSubject(loginName).withClaim("remark", remark == null ? "" : remark.toJSONString()).withExpiresAt(date).sign(algorithm);
    }

    public static String sign(String loginName, Map<String, Object> map) {
        JwtBean jwtBean = (JwtBean)ContextUtil.getBean(JWT_BEAN_STR);
        Date date = new Date(System.currentTimeMillis() + jwtBean.getExpireTime());
        Algorithm algorithm = Algorithm.HMAC256((String)jwtBean.getTokenSecret());
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("typ", "JWT");
        header.put("alg", "HS256");
        JWTCreator.Builder builder = JWT.create();
        builder.withHeader(header);
        builder.withClaim("loginName", loginName);
        if (map != null) {
            for (String key : map.keySet()) {
                builder.withClaim(key, map.get(key) + "");
            }
        }
        builder.withIssuedAt(new Date());
        builder.withExpiresAt(date);
        builder.withIssuer("jdevelops");
        builder.withSubject(loginName);
        builder.withJWTId(UUID.randomUUID().toString());
        return builder.sign(algorithm);
    }

    public static boolean verity(String token) {
        try {
            JwtBean jwtBean = (JwtBean)ContextUtil.getBean(JWT_BEAN_STR);
            Algorithm algorithm = Algorithm.HMAC256((String)jwtBean.getTokenSecret());
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            verifier.verify(token);
            return true;
        }
        catch (Exception e) {
            logger.error("token\u8fc7\u671f");
            return false;
        }
    }

    public static Map<String, Object> verityForMap(String token) {
        try {
            JwtBean jwtBean = (JwtBean)ContextUtil.getBean(JWT_BEAN_STR);
            Algorithm algorithm = Algorithm.HMAC256((String)jwtBean.getTokenSecret());
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT jwt = verifier.verify(token);
            Map claims = jwt.getClaims();
            return JwtUtil.getClaims(claims);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ResultCodeEnum.TOKEN_ERROR.getMessage(), e);
        }
    }

    public static String getClaim(String token, String claim) {
        DecodedJWT jwt = JWT.decode((String)token);
        return jwt.getClaim(claim == null ? "loginName" : claim).asString();
    }

    public static String getSubject(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        return jwt.getSubject();
    }

    public static Map<String, Object> parseJwt(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        Map claims = jwt.getClaims();
        return JwtUtil.getClaims(claims);
    }

    public static Map<String, Object> parseJwtVerify(String token) {
        boolean verity = JwtUtil.verity(token);
        if (!verity) {
            throw new JWTVerificationException("token\u8fc7\u671f");
        }
        DecodedJWT jwt = JWT.decode((String)token);
        Map claims = jwt.getClaims();
        return JwtUtil.getClaims(claims);
    }

    public static Map<String, Claim> parseJwt2(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        return jwt.getClaims();
    }

    public static String getToken(ServerHttpRequest request) {
        return Optional.ofNullable(request.getHeaders().get((Object)"token")).map(t -> (String)t.get(0)).orElse(null);
    }

    public static Map<String, Object> getClaims(Map<String, Claim> claims) {
        Iterator<String> iterator = claims.keySet().iterator();
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        while (iterator.hasNext()) {
            String key = iterator.next();
            Claim claim = claims.get(key);
            resMap.put(key, claim.as(Object.class));
        }
        return resMap;
    }
}

