/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.http.core;

import cn.jdevelops.http.core.IpUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacUtil {
    private static final String WIN = "win";
    private static final String WINDOWS = "Windows";
    private static final String LINUX = "Linux";
    private static String macAddressStr = null;
    private static String computerName = System.getenv().get("COMPUTERNAME");
    private static final String[] WINDOWS_COMMAND = new String[]{"ipconfig", "/all"};
    private static final String[] LINUX_COMMAND = new String[]{"/sbin/ifconfig", "-a"};
    private static final Pattern MAC_PATTERN = Pattern.compile(".*((:?[0-9a-f]{2}[-:]){5}[0-9a-f]{2}).*", 2);

    private MacUtil() {
    }

    public static List<String> getMacAddressList() throws IOException {
        String line;
        String[] command;
        ArrayList<String> macAddressList = new ArrayList<String>();
        String os = System.getProperty("os.name");
        if (os.startsWith(WINDOWS)) {
            command = WINDOWS_COMMAND;
        } else if (os.startsWith(LINUX)) {
            command = LINUX_COMMAND;
        } else {
            throw new IOException("Unknow operating system:" + os);
        }
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = bufReader.readLine()) != null) {
            Matcher matcher = MAC_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            macAddressList.add(matcher.group(1));
        }
        process.destroy();
        bufReader.close();
        return macAddressList;
    }

    public static String getMacAddress() {
        if (macAddressStr == null || "".equals(macAddressStr)) {
            StringBuilder sb = new StringBuilder();
            try {
                List<String> macList = MacUtil.getMacAddressList();
                for (String amac : macList) {
                    if ("0000000000E0".equals(amac)) continue;
                    sb.append(amac);
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            macAddressStr = sb.toString();
        }
        return macAddressStr;
    }

    public static String getComputerName() {
        if (computerName == null || "".equals(computerName)) {
            computerName = System.getenv().get("COMPUTERNAME");
        }
        return computerName;
    }

    public static String getComputerId() {
        String id = MacUtil.getMacAddress();
        if (id == null || "".equals(id)) {
            try {
                return IpUtil.getIpAddrAndName();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return computerName;
    }

    public static String win2Linux(String path) {
        String os = System.getProperty("os.name");
        path = os.toLowerCase().startsWith(WIN) ? path.replace("/", "\\") : path.replace("\\", "/");
        return path;
    }
}

