/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.http.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class UpstreamCheckUtils {
    private static final String COLONS = ":";
    private static final Pattern PATTERN = Pattern.compile("(http:\\/\\/|https:\\/\\/)?(?:(?:[0,1]?\\d?\\d|2[0-4]\\d|25[0-5])\\.){3}(?:[0,1]?\\d?\\d|2[0-4]\\d|25[0-5]):\\d{0,5}");
    private static final String HTTP = "http";

    public static boolean checkUrl(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        if (UpstreamCheckUtils.checkIP(url)) {
            String[] hostPort;
            if (url.startsWith(HTTP)) {
                String[] http = StringUtils.split((String)url, (String)"\\/\\/");
                hostPort = StringUtils.split((String)http[1], (String)COLONS);
            } else {
                hostPort = StringUtils.split((String)url, (String)COLONS);
            }
            return UpstreamCheckUtils.isHostConnector(hostPort[0], Integer.parseInt(hostPort[1]));
        }
        return UpstreamCheckUtils.isHostReachable(url);
    }

    private static boolean checkIP(String url) {
        return PATTERN.matcher(url).matches();
    }

    private static boolean isHostConnector(String host, int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private static boolean isHostReachable(String host) {
        try {
            return InetAddress.getByName(host).isReachable(1000);
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

