/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.http.core;

import cn.jdevelops.enums.number.NumEnum;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpUtil.class);
    static final String UNKNOWN = "unKnown";

    public static String getPoxyIp(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (null != ip && !UNKNOWN.equalsIgnoreCase(ip)) {
            int index = ip.indexOf(",");
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        ip = request.getHeader("X-Real-IP");
        if (null != ip && !UNKNOWN.equalsIgnoreCase(ip)) {
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String getRealIp() throws SocketException {
        Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp() || !netInterface.getDisplayName().contains("Intel") && !netInterface.getDisplayName().contains("Realtek")) continue;
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress ip = addresses.nextElement();
                if (ip == null || !(ip instanceof Inet4Address)) continue;
                return ip.getHostAddress();
            }
            break block0;
        }
        return "127.0.0.1";
    }

    public static String getMacAddress(String ip) {
        String macAddress = "";
        try {
            Process p = Runtime.getRuntime().exec("nbtstat -A " + ip);
            InputStreamReader ir = new InputStreamReader(p.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            for (int i = 1; i < NumEnum.HUNDRED.getNum(); ++i) {
                String str = input.readLine();
                if (str == null || 1 >= str.indexOf("MAC Address")) continue;
                macAddress = str.substring(str.indexOf("MAC Address") + 14);
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return macAddress;
    }

    public static String ipConvert(String domainName) {
        String ip;
        try {
            ip = InetAddress.getByName(domainName).getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return domainName;
        }
        return ip;
    }

    public static String getIpAddrAndName() throws IOException {
        return InetAddress.getLocalHost().toString();
    }

    public static String getIpAddr() throws IOException {
        return InetAddress.getLocalHost().getHostAddress();
    }
}

