/*
 * Decompiled with CFR 0.152.
 */
package cn.jdevelops.http.core;

import cn.jdevelops.enums.http.HttpEnum;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class HttpContextUtils {
    public static Map<String, String> getParameterMapAll(HttpServletRequest request) {
        Enumeration parameters = request.getParameterNames();
        HashMap<String, String> params = new HashMap<String, String>(16);
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = request.getParameter(parameter);
            params.put(parameter, value);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        ServletInputStream inputStream = null;
        BufferedReader reader = null;
        try {
            String line;
            inputStream = request.getInputStream();
            reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (!HttpEnum.POST.getStr().equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith(HttpEnum.MULTIPART_PATHSEPARATOR.getStr().toLowerCase());
    }
}

